% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_metanet.R
\name{build_metanet}
\alias{build_metanet}
\title{Build metanetwork object}
\usage{
build_metanet(
  metaweb,
  abTable = NULL,
  trophicTable = NULL,
  compute_local_nets = TRUE
)
}
\arguments{
\item{metaweb}{metaweb of the metanetwork, object of class 'graph', 'matrix', 'data.frame' or 'dgCMatrix'.
Metaweb needs to be directed and connected. This argument must be non-null.}

\item{abTable}{node abundances in local networks, matrix of class 'matrix',
columns must have names corresponding to node labels of the metaweb,
rows are node abundances in local networks.
Default is null, in that case, uniform abundances are assigned}

\item{trophicTable}{a 'matrix' or 'data.frame' indicating hierarchy of the nodes.
Names of the columns correspond to the different resolutions.
It indicates the membership of each node of the metaweb. Default is null.}

\item{compute_local_nets}{a boolean, indicates whether local networks must be computed or not.
Default is \code{TRUE}}
}
\value{
an object of S3 class 'metanetwork'
}
\description{
Build metanetwork object
}
\examples{
library(metanetwork)
library(igraph)
#with a single metaweb
g = igraph::make_ring(5,directed = TRUE)
meta = build_metanet(g)

#on Angola dataset (re-building the dataset)
data("meta_angola")
metaweb = meta_angola$metaweb
abTable = meta_angola$abTable
trophicTable = meta_angola$trophicTable 
meta_angola = build_metanet(metaweb,abTable,trophicTable)
print(meta_angola)

}
