% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metapro.R
\name{lancaster}
\alias{lancaster}
\title{Lancaster}
\usage{
lancaster(p, weight, is.onetail = TRUE, eff.sign)
}
\arguments{
\item{p}{A numeric vector of p-values}

\item{weight}{A numeric vector of weights (e.g., samples sizes)}

\item{is.onetail}{Logical. If set TRUE, p-values are combined without considering the direction of effect, and vice versa. Default: TRUE.}

\item{eff.sign}{A vector of signs of effect sizes (1 or -1). It works when is.onetail = FALSE}
}
\value{
p : Combined p-value

overall.eff.direction : The direction of combined effects.
}
\description{
P-value combination based on Lancaster's procedure
}
\examples{
lancaster(p=c(0.01,0.2,0.8), weight=c(20,50,10), is.onetail=FALSE, eff.sign=c(1,1,1))
}
\references{
Becker BJ (1994). “Combining significance levels.” In Cooper H, Hedges LV (eds.), A handbook of research synthesis, 215–230. Russell Sage, New York.

Lancaster HO (1949). “Combination of probabilities arising from data in discrete distributions.” Biometrika, 36, 370–382.
}
