% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{drop_unspec_vars}
\alias{drop_unspec_vars}
\title{Drop Unspecified Variables}
\usage{
drop_unspec_vars(dataset, metacore, dataset_name = deprecated())
}
\arguments{
\item{dataset}{Dataset to change}

\item{metacore}{metacore object that only contains the specifications for the
dataset of interest.}

\item{dataset_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Optional string to specify
the dataset. This is only needed if the metacore object provided hasn't already
been subsetted.\cr
Note: Deprecated in version 0.2.0. The \code{dataset_name} argument will be removed
in a future release. Please use \code{metacore::select_dataset} to subset the
\code{metacore} object to obtain metadata for a single dataset.}
}
\value{
Dataset with only specified columns
}
\description{
This function drops all unspecified variables. It will throw and error if the
dataset does not contain all expected variables.
}
\examples{
library(metacore)
library(haven)
library(dplyr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
data <- read_xpt(metatools_example("adsl.xpt")) \%>\%
  select(USUBJID, SITEID) \%>\%
  mutate(foo = "Hello")
drop_unspec_vars(data, spec)
}
