% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sad.meteESF.R
\name{metePhi}
\alias{metePhi}
\title{Equation of the METE species abundance distribution}
\usage{
metePhi(n, la1, la2, Z, S0, N0, E0)
}
\arguments{
\item{n}{the value (number of individuals) at which to calculate \deqn{\Phi}}

\item{la1,la2}{Lagrange multipliers}

\item{Z}{partition function}

\item{S0}{Total number of species}

\item{N0}{Total number of individuals}

\item{E0}{Total metabolic rate}
}
\value{
numeric
}
\description{
\code{metePhi} returns the species abundance distribution
(Phi(n)) predicted by METE; vectorized in n
}
\details{
See Examples
}
\examples{
esf1=meteESF(spp=arth$spp,
              abund=arth$count,
              power=arth$mass^(.75),
              minE=min(arth$mass^(.75)))
metePhi(min(arth$mass^(.75)),
       esf1$La[1],esf1$La[2],
       esf1$Z,esf1$state.var['S0'],
       esf1$state.var['N0'],
       esf1$state.var['E0'])
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
\code{sad.mete}
}
\keyword{manip}

