% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.meteRelat.R
\name{plot.meteRelat}
\alias{plot.meteRelat}
\title{Plot predicted METE relationships and associated observed relationship seen in data}
\usage{
\method{plot}{meteRelat}(x, add.legend = TRUE, th.col = "red", ...)
}
\arguments{
\item{x}{a \code{meteRelat} object}

\item{add.legend}{logical; add a legend}

\item{th.col}{line color of theoretical prediction}

\item{...}{arguments to be passed to \code{plot}}
}
\description{
\code{plot.meteRelat} plots both the theoretical prediction and data for a
\code{meteRelat} object
}
\details{
\code{plot.meteRelat} automatically extracts the prediction and data (if used
in \code{meteESF}) from the \code{meteDist} object. Additional plotting
arguments can be passed to \code{...}.
}
\examples{
data(anbo)
anbo.sar <- meteSAR(anbo$spp, anbo$count, anbo$row, anbo$col, Amin=1, A0=16)
plot(anbo.sar)
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
meteSAR
}

