% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_cox}
\alias{fit_cox}
\title{Function that fits Cox proportional hazards models}
\usage{
fit_cox(
  x,
  y,
  strata,
  weights,
  offset,
  control,
  method,
  rownames,
  nocenter,
  fast = TRUE
)
}
\arguments{
\item{x}{a matrix of predictors excluding intercept with nobs observations.}

\item{y}{a \code{Surv} object.}

\item{strata, control, rownames, nocenter}{passed to \code{\link[survival:agreg.fit]{survival::coxph.fit()}}.}

\item{weights}{a numeric vector of length nobs of 'prior weights' to be used
in the fitting process.}

\item{offset}{a numeric vector of length nobs of of a priori known component
to be included in the linear predictor during fitting.}

\item{method}{a character string specifying the method for tie handling.
See \code{\link[survival:coxph]{survival::coxph()}}.}

\item{fast}{a logical which determines how the model is fitted. The default
\code{TRUE} uses fast fitting routines (i.e. \code{\link[survival:agreg.fit]{survival::coxph.fit()}}), while
\code{FALSE}uses the normal fitting routines (\code{\link[survival:coxph]{survival::coxph()}}) (used for
the final output of \code{mfp2}).}
}
\value{
A list with the following components:
\itemize{
\item \code{logl}: the log likelihood of the fitted model.
\item \code{coefficients}: regression coefficients.
\item \code{df}: number of parameters (degrees of freedom).
\item \code{sse}: residual sum of squares (not used).
\item \code{fit}: the fitted model object.
}
}
\description{
Function that fits Cox proportional hazards models
}
