% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changefunctions.R
\name{elbow}
\alias{elbow}
\title{Finding corner of a vector of ordered transformed p values}
\usage{
elbow(zvec, rbuff = 25, h = 30)
}
\arguments{
\item{zvec}{vector of ordered transformed p values}

\item{rbuff}{scaler, by default 25. Controls the right buffer.}

\item{h}{scaler, default 30. Controls the window size.}
}
\value{
vector with two elements, containing estimates of the index of corner 

       $dav: by average method.
       $dlm: by maximum gradient method.
}
\description{
Finds corner of a vector of ordered transformed p values.
}
\details{
The corner point of ordered p values indicate the point where the change from the alternative to null happens. So, by detecting that point we get an estimate of the number of true alternatives. 

This function uses two methods for corner detection. One method is by transforming the vectors by taking their first difference and centering them around a theoretical mean for null case. The other method is by detecting the maximum change in gradient at each point. These methods will be denoted by dav and dlm respectively.
}
\examples{
\dontrun{         
n = 50;m = 250;m0 = 20;
sigeff = 1;
Sigma <- 0.25*diag(m)
X <- datgen(n,m,m0,sigeff,Sigma = Sigma)
porder <- pboot.1sample(X=X,B=500,ncpus = 1)
out <- elbow(zvec = porder[1,])
out
}
}

