% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootfunctions.R
\name{ptrans}
\alias{ptrans}
\title{Transformation of order statistics of the p value distributions}
\usage{
ptrans(porder, trans = "default")
}
\arguments{
\item{porder}{matrix of p value order statistics, rows indicate replicates}

\item{trans}{one of ("default","normal","none") indicating trnasformation of -log(1-p), which is by default. Or inverse normal cdf transformation or no transformation.}
}
\value{
matrix with transformed distribution.
}
\description{
This function applys transformation on the bootstrap distribution of order statistics of p values.
}
\details{
The transformation of p values must be monotonically increasing. The user can use their own transofrmation, however, this function supports only the commonly used transformations. These are -log(1-p) transformation, inverse normal cdf and identiy transformation.
}
\examples{
\dontrun{
X <- datgen(n=100,m=80,m0=20,sigeff=1,Sigma = 0.25*diag(80))
porder <- pboot.1sample(X=X,B=100,ncpus = 1)
porder.tr <- ptrans(porder,trans="normal")
plotpboot(porder.tr)
}
}

