% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descMissData.R
\name{descMissData}
\alias{descMissData}
\title{Lists missing data patterns in the specified dataset}
\usage{
descMissData(y, covs, data, plot = FALSE)
}
\arguments{
\item{y}{The analysis model outcome, specified as a string}

\item{covs}{The analysis model covariate(s), specified as a string (space
delimited)}

\item{data}{A data frame containing the specified analysis model outcome and
covariate(s)}

\item{plot}{If TRUE, displays a plot using \link[mice]{md.pattern} to
visualise the missing data patterns; use plot = FALSE (the default) to
disable the plot}
}
\value{
A summary of the missing data patterns
}
\description{
This function summarises the missing data patterns in the specified dataset.
Each row in the output corresponds to a missing data pattern (1=observed,
0=missing). The number and percentage of observations is also displayed for
each missing data pattern. The first column indicates the number of missing
data patterns. The second column refers to the analysis model outcome
('y'), with all other variables ('covs') displayed in subsequent columns.
Alternatively, 'y' can be used to display the primary variable of interest,
e.g. 'y' could refer to the exposure, with all other variables listed in
'covs'.
}
\examples{
descMissData(y="bmi7", covs="matage mated", data=bmi)
descMissData(y="bmi7", covs="matage mated pregsize bwt", data=bmi, plot=TRUE)
}
