% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_comp.R
\name{multi_comp}
\alias{multi_comp}
\title{Multiplicative component description of origin-destination migration flow tables}
\usage{
multi_comp(m)
}
\arguments{
\item{m}{\code{matrix} or \code{array} of migration flows}
}
\value{
\code{matrix} or \code{array} of multiplicative components of \code{m}. When output is an array the total for each table of origin-destination flows is used.
}
\description{
Multiplicative component descriptions of \emph{n}-dimension flow tables based on total reference coding system.
}
\examples{
r <- LETTERS[1:4]
m0 <- matrix(data = c(0, 100, 30, 70, 50, 0, 45, 5, 60, 35, 0, 40, 20, 25, 20, 0), 
             nrow = 4, ncol = 4, byrow = TRUE, dimnames = list(orig = r, dest = r))
addmargins(m0)
multi_comp(m = m0)

# data frame
library(dplyr)
italy_area \%>\%
  filter(year == 2000) \%>\%
  multi_comp() \%>\%
  round(digits = 3)
}
\references{
Rogers, A., Willekens, F., Little, J., & Raymer, J. (2002). Describing migration spatial structure. Papers in Regional Science, 81(1), 29–48. https://doi.org/10.1007/s101100100090

Raymer, J., Bonaguidi, A., & Valentini, A. (2006). Describing and projecting the age and spatial structures of interregional migration in Italy. Population, Space and Place, 12(5), 371–388. https://doi.org/10.1002/psp.414
}
