% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_matrix_optim.R
\name{net_matrix_optim}
\alias{net_matrix_optim}
\title{Estimate Migration Flows to Match Net Totals via Quadratic Optimization}
\usage{
net_matrix_optim(net_tot, m, zero_mask = NULL, maxit = 500, tol = 1e-06)
}
\arguments{
\item{net_tot}{A numeric vector of net migration totals for each region. Must sum to zero.}

\item{m}{A square numeric matrix providing prior flow estimates. Must have dimensions \code{length(net_tot) × length(net_tot)}.}

\item{zero_mask}{A logical matrix of the same dimensions as \code{m}, where \code{TRUE} indicates forbidden (structurally zero) flows. Defaults to disallowing diagonal flows.}

\item{maxit}{Maximum number of iterations to perform. Default is \code{500}.}

\item{tol}{Numeric tolerance for checking whether \code{sum(net_tot) == 0}. Default is \code{1e-6}.}
}
\value{
A named list with components:
\describe{
\item{\code{n}}{Estimated matrix of flows satisfying the net constraints.}
\item{\code{it}}{Number of optimization iterations (if available).}
\item{\code{tol}}{Tolerance used for the net flow balance check.}
\item{\code{value}}{Objective function value (sum of squared deviations).}
\item{\code{convergence}}{Logical indicating successful convergence.}
\item{\code{message}}{Solver message or status.}
}
}
\description{
Solves for an origin–destination flow matrix that satisfies directional net migration constraints
while minimizing squared deviation from a prior matrix.
}
\details{
The function minimizes:
\deqn{\sum_{i,j} (y_{ij} - m_{ij})^2}
subject to directional net flow constraints:
\deqn{\sum_j y_{ji} - \sum_j y_{ij} = \text{net}_i}
and non-negativity constraints on all flows. Structural zeros are enforced using \code{zero_mask}.
Internally uses \code{optim()} or a constrained quadratic programming solver.
}
\examples{
m <- matrix(c(0, 100, 30, 70,
              50,   0, 45,  5,
              60,  35,  0, 40,
              20,  25, 20,  0),
            nrow = 4, byrow = TRUE,
            dimnames = list(orig = LETTERS[1:4], dest = LETTERS[1:4]))
addmargins(m)
sum_region(m)

net <- c(30, 40, -15, -55)
result <- net_matrix_optim(net_tot = net, m = m)
result$n |>
  addmargins() |>
  round(2)
sum_region(result$n)
}
\seealso{
\code{\link{net_matrix_entropy}()} for KL divergence minimization,
\code{\link{net_matrix_ipf}()} for iterative proportional fitting,
and \code{\link{net_matrix_lp}()} for linear programming with L1 loss.
}
