% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mismm.R
\name{predict.mismm}
\alias{predict.mismm}
\title{Predict method for \code{mismm} object}
\usage{
\method{predict}{mismm}(
  object,
  new_data,
  type = c("class", "raw"),
  layer = c("bag", "instance"),
  new_bags = "bag_name",
  new_instances = "instance_name",
  kernel = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{mismm}.}

\item{new_data}{A data frame to predict from. This needs to have all of the
features that the data was originally fitted with.}

\item{type}{If \code{'class'}, return predicted values with threshold of 0 as
-1 or +1.  If \code{'raw'}, return the raw predicted scores.}

\item{layer}{If \code{'bag'}, return predictions at the bag level.  If
\code{'instance'}, return predictions at the instance level.}

\item{new_bags}{A character or character vector.  Can specify a singular
character that provides the column name for the bag names in \code{new_data}
(default \code{'bag_name'}).  Can also specify a vector of length
\code{nrow(new_data)} that has bag name for each row.}

\item{new_instances}{A character or character vector.  Can specify a singular
character that provides the column name for the instance names in
\code{new_data} (default \code{'instance_name'}).  Can also specify a vector of length
\code{nrow(new_data)} that has instance name for each row.}

\item{kernel}{An optional pre-computed kernel matrix at the instance level or
\code{NULL} (default \code{NULL}). The rows should correspond to instances in the new
data to predict, and columns should correspond to instances in the original
training data, such as a call to \code{\link[=kme]{kme()}}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A tibble with \code{nrow(new_data)} rows.  If \code{type = 'class'}, the tibble
will have a column \code{.pred_class}.  If \code{type = 'raw'}, the tibble will have
a column \code{.pred}.
}
\description{
Predict method for \code{mismm} object
}
\details{
When the object was fitted using the \code{formula} method, then the parameters
\code{new_bags} and \code{new_instances} are not necessary, as long as the names match
the original function call.
}
\examples{
mil_data <- generate_mild_df(nbag = 15, nsample = 20, positive_prob = 0.15,
                             sd_of_mean = rep(0.1, 3))

mdl1 <- mismm(mil_data, control = list(sigma = 1/5))

# bag level predictions
library(dplyr)
mil_data \%>\%
    bind_cols(predict(mdl1, mil_data, type = "class")) \%>\%
    bind_cols(predict(mdl1, mil_data, type = "raw")) \%>\%
    distinct(bag_name, bag_label, .pred_class, .pred)

# instance level prediction
mil_data \%>\%
    bind_cols(predict(mdl1, mil_data, type = "class", layer = "instance")) \%>\%
    bind_cols(predict(mdl1, mil_data, type = "raw", layer = "instance")) \%>\%
    distinct(bag_name, instance_name, bag_label, .pred_class, .pred)

}
\seealso{
\code{\link[=mismm]{mismm()}} for fitting the \code{mismm} object.
}
\author{
Sean Kent
}
