% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Initialization.R
\name{initialisation_params_bayesian}
\alias{initialisation_params_bayesian}
\title{Initialization of mimiSBM parameters}
\usage{
initialisation_params_bayesian(
  A,
  K,
  Q,
  beta_0 = rep(1/2, K),
  theta_0 = rep(1/2, Q),
  eta_0 = array(rep(1/2, K * K * Q), c(K, K, Q)),
  xi_0 = array(rep(1/2, K * K * Q), c(K, K, Q)),
  type_init = "SBM",
  nbCores = 2
)
}
\arguments{
\item{A}{an array of dim=c(N,N,V)}

\item{K}{Number of clusters}

\item{Q}{Number of components}

\item{beta_0}{hyperparameters for beta}

\item{theta_0}{hyperparameters for theta}

\item{eta_0}{hyperparameters for eta}

\item{xi_0}{hyperparameters for xi}

\item{type_init}{select the type of initialization type_init=c("SBM","Kmeans","random")}

\item{nbCores}{the number of cores used to parallelize the calculations of the various SBMs}
}
\value{
a list \code{params} updated
}
\description{
Initialization of mimiSBM parameters
}
