% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{prepare_newdata}
\alias{prepare_newdata}
\title{Design Matrix for a Model}
\usage{
prepare_newdata(fit, newdata = NULL)
}
\arguments{
\item{fit}{An object of class \code{lnm} whose estimate slot contains the 'rstan'
fitted logistic normal multinomial model.}

\item{newdata}{A data.frame containing variables in the formula definition of
the fit, but which hasn't been converted into the matrix format needed for
internal prediction.}
}
\value{
A matrix containing the design matrix that can be multiplied with the
fitted Beta parameter to get fitted compositions.
}
\description{
This is a helper function to form the design matrix for an LNM regression
starting from a fitted model's formula object. It is an analog of
model.matrix for the multiresponse setting.
}
\examples{
example_data <- lnm_data(N = 10, K = 5)
xy <- dplyr::bind_cols(example_data[c("X", "y")])
fit <- lnm(
    starts_with("y") ~ starts_with("x"), xy,
    iter = 5, output_samples = 5
)
prepare_newdata(fit, example_data[["X"]])
}
