% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_rank.R
\name{delete_MAR_rank}
\alias{delete_MAR_rank}
\title{Create MAR values using a ranking mechanism}
\usage{
delete_MAR_rank(
  ds,
  p,
  cols_mis,
  cols_ctrl,
  n_mis_stochastic = FALSE,
  ties.method = "average",
  miss_cols,
  ctrl_cols
)
}
\arguments{
\item{ds}{A data frame or matrix in which missing values will be created.}

\item{p}{A numeric vector with length one or equal to length \code{cols_mis};
the probability that a value is missing.}

\item{cols_mis}{A vector of column names or indices of columns in which
missing values will be created.}

\item{cols_ctrl}{A vector of column names or indices of columns, which
controls the creation of missing values in \code{cols_mis}. Must be of the
same length as \code{cols_mis}.}

\item{n_mis_stochastic}{Logical, should the number of missing values be
stochastic? If \code{n_mis_stochastic = TRUE}, the number of missing values
for a column with missing values \code{cols_mis[i]} is a random variable
with expected value \code{nrow(ds) * p[i]}. If \code{n_mis_stochastic =
FALSE}, the number of missing values will be deterministic. Normally, the
number of missing values for a column with missing values
\code{cols_mis[i]} is \code{round(nrow(ds) * p[i])}. Possible deviations
from this value, if any exists, are documented in Details.}

\item{ties.method}{How ties are handled. Passed to \code{\link[base]{rank}}.}

\item{miss_cols}{Deprecated, use \code{cols_mis} instead.}

\item{ctrl_cols}{Deprecated, use \code{cols_ctrl} instead.}
}
\value{
An object of the same class as \code{ds} with missing values.
}
\description{
Create missing at random (MAR) values using a ranking mechanism in a data
frame or a matrix
}
\details{
This function creates missing at random (MAR) values in the columns
specified by the argument \code{cols_mis}.
The probability for missing values is controlled by \code{p}.
If \code{p} is a single number, then the overall probability for a value to
be missing will be \code{p} in all columns of \code{cols_mis}.
(Internally \code{p} will be replicated to a vector of the same length as
\code{cols_mis}.
So, all \code{p[i]} in the following sections will be equal to the given
single number \code{p}.)
Otherwise, \code{p} must be of the same length as \code{cols_mis}.
In this case, the overall probability for a value to be missing will be
\code{p[i]} in the column \code{cols_mis[i]}.
The position of the missing values in \code{cols_mis[i]} is controlled by
\code{cols_ctrl[i]}.
The following procedure is applied for each pair of \code{cols_ctrl[i]} and
\code{cols_mis[i]} to determine the positions of missing values:

At first, the probability for a value to be missing is calculated. This
probability for a missing value in a row of \code{cols_mis[i]} is
proportional to the rank of the value in \code{cols_ctrl[i]} in the same row.
If \code{n_mis_stochastic = FALSE} these probabilities are given to the
\code{prob} argument of \code{\link[base]{sample}}. If \code{n_mis_stochastic
= TRUE}, they are scaled to sum up to \code{nrow(ds) * p[i]}. Then for each
probability a uniformly distributed random number is generated. If this
random number is less than the probability, the value in \code{cols_mis[i]}
is set \code{NA}.

The ranks are calculated via \code{\link[base]{rank}}.
The argument \code{ties.method} is directly passed to this function.
Possible choices for \code{ties.method} are documented in
\code{\link[base]{rank}}.

For high values of \code{p} it is mathematically not possible to get
probabilities proportional to the ranks. In this case, a warning is given.
This warning can be silenced by setting the option
\code{missMethods.warn.too.high.p} to false.
}
\examples{
ds <- data.frame(X = 1:20, Y = 101:120)
delete_MAR_rank(ds, 0.2, "X", "Y")
}
\references{
Santos, M. S., Pereira, R. C., Costa, A. F., Soares, J. P.,
  Santos, J., & Abreu, P. H. (2019). Generating Synthetic Missing Data: A
  Review by Missing Mechanism. \emph{IEEE Access}, 7, 11651-11667
}
\seealso{
\code{\link[base]{rank}}, \code{\link{delete_MNAR_rank}}

Other functions to create MAR: 
\code{\link{delete_MAR_1_to_x}()},
\code{\link{delete_MAR_censoring}()},
\code{\link{delete_MAR_one_group}()}
}
\concept{functions to create MAR}
