% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr_new.R
\name{Pareto}
\alias{Pareto}
\alias{dpareto}
\alias{ppareto}
\alias{qpareto}
\alias{rpareto}
\title{The Pareto Distribution}
\usage{
dpareto(x, scale = 1, shape = 1, log = FALSE)

ppareto(q, scale = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

qpareto(p, scale = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

rpareto(n, scale = 1, shape = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{scale}{scale parameter.}

\item{shape}{shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}, default: TRUE.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dpareto} gives the density, \code{ppareto} gives the distribution function, \code{qpareto} gives the quantile function, and
        \code{rpareto} generates random deviates.

        Invalid arguments will result in return value NaN, with a warning.
}
\description{
Density, distribution function, quantile function and random generation for the Pareto distribution with
scale and shape parameters.
}
\details{
The Pareto distribution function with scale parameter \eqn{s} and shape parameter
         \eqn{\alpha} has density given by
         \deqn{f(x)=\alpha s^\alpha/x^(\alpha+1)} for \eqn{x\ge s}. The cumulative distribution function is
         \deqn{F(x)=1-(s/x)^\alpha} for \eqn{x\ge s}. See \url{https://en.wikipedia.org/wiki/Pareto_distribution}
         for more details.
}
\examples{
dpareto(seq(1, 5), 1, 1)
qpareto(ppareto(seq(1, 5), 1, 1), 1 ,1)
rpareto(5, 1, 1)
}
\seealso{
\code{\link{paretodist}}
}
