% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_global_influence.R
\name{influence.mixpoissonreg}
\alias{influence.mixpoissonreg}
\alias{hatvalues.mixpoissonreg}
\alias{cooks.distance.mixpoissonreg}
\title{Global Influence Diagnostics for Mixed Poisson Regression Models}
\usage{
\method{hatvalues}{mixpoissonreg}(model, parameters = c("mean", "precision"), ...)

\method{cooks.distance}{mixpoissonreg}(
  model,
  type = c("CD", "GCD", "GCDmean", "GCDprecision", "LD", "QD"),
  hat = c("mean", "precision"),
  ...
)

\method{influence}{mixpoissonreg}(model, do.coef = TRUE, ...)
}
\arguments{
\item{model}{a \code{mixpoissonreg} object.}

\item{parameters}{the parameter to which the hat values will be computed. The options are 'mean' and 'precision'. The default is 'mean'. For hatvalues with respect to the mean
the model must be fitted with 'x' set to TRUE, and for hatvalues with respect to the precision the model must be fitted with 'w' set to TRUE.}

\item{...}{Currently not used.}

\item{type}{the type of Cook's distance to be used. The options are 'CD', the standard Cook's distance;
'GCD', the generalized Cook's distance with respect to all parameters, Zhu et al. (2001);
'GCDmean', the generalized Cook's distance with respect to the mean parameters;
'GCDprecision', the generalized Cook's distance with respect to the precision parameters;
'LD', the likelihood displacement (also known as likelihood distance), see Cook and Weisberg (1982); 'QD', the Q-displacement, see Zhu et al. (2001).
See 'details' for more informations. For 'GCD', 'GCDmean', 'LD' and 'QD', the model must be fitted with 'x' set to TRUE,
and for 'GCD', 'GCDprecision', 'LD' and 'QD', the model must be fitted with 'w' set to TRUE. For 'CD', if 'hat' is set to 'mean',
the model must be fitted with 'x' set to TRUE, whereas
if 'hat' is set to 'precision', the model must be fitted with 'w' set to TRUE.}

\item{hat}{hat values \code{H[i,i]}. The default is obtained through the second-derivative of the Q-function in the spirit of Zhu et al. (2001) and Pregibon (1981), see details.}

\item{do.coef}{logical indicating if the the approximation to the change of coefficients values after case removal are desired. The model must be fitted with x = TRUE. See details for further explanations.}
}
\value{
The method \code{influence.mixpoissonreg} returns a list containing
\emph{hat.mean}, a vector containing the hat values with respect to the mean, \emph{hat.precision},
a vector containing the hat values with respect to the precision, \emph{coefficients.mean} (if \code{do.coef=TRUE}), a matrix
containing the first
order approximations for the mean-related coefficients after the removal
of each observation, \emph{coefficients.precision} (if \code{do.coef=TRUE}), a matrix containing the first
order approximations for the precision-related coefficients after the removal
of each observation, \emph{pear.res}, a vector containing the Pearson residuals,
\emph{score.res}, a vector containing the score residuals.

The \emph{cooks.distance.mixpoissonreg} returns a vector containing the Cook's distances.

The \emph{hatvalues.mixpoissonreg} returns a vector containing the hat values.
}
\description{
These functions provides global influence diagnostic quantities such as Cook's distance, hat values, generalized Cook's distance (through argument
on \code{cooks.distance.mixpoissonreg} function), likelihood displacement (through argument
on \code{cooks.distance.mixpoissonreg} function) and Q-displacement (through argument
on \code{cooks.distance.mixpoissonreg} function).
}
\details{
For hat values of mixed Poisson regression models, we follow Zhu et al. (2001) to consider the negative of the hessian of the Q-function as weight matrix, and follow
Pregibon (1981) to define the 'hat' matrix with respect to this weight matrix. We can consider the hessian of the Q-function with respect to mean-related parameters,
which is the default. We can also consider the hessian of the Q-function with respect to the precision-related parameters to give rise to hat values related to the precision
parameters.

The Generalized Cook's distance and Q-displacement for EM-based models were defined in Zhu et al. (2001) and computed for mixed Poisson regression models
in Barreto-Souza and Simas (2016). We implemented first-order approximation to these quantities to make it computationally feasible. These first-order approximations
are available in Barreto-Souza and Simas (2016). We also provide versions of generalized Cook's distance for mean-related or precision-related parameters, whose
details can be found in Barreto-Souza and Simas (2016).

In the influence method we provide a 'do.coef' argument that computes first-order approximations to the impact of removal of each case to each parameter, in the
same spirit as the 'do.coeff' argument in 'influence.lm'.
}
\references{
DOI:10.1007/s11222-015-9601-6 \doi{10.1007/s11222-015-9601-6}(Barreto-Souza and Simas, 2016)

Cook, D.R. and Weisberg, S. (1982) \emph{Residuals and Influence in Regression}. (New York: Chapman and Hall, 1982)

Pregibon, D. (1981) \emph{Logistic Regression Diagnostics}. Ann. Stat. 9, 705-724.

Zhu, H.T., Lee, S.Y., Wei, B.C., Zhu, J. (2001) \emph{Case-deletion measures formodels with incomplete data.} Biometrika, 88, 727–737.
}
