% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_tidy_mixpoissonreg.R
\name{tidy_local_influence.mixpoissonreg}
\alias{tidy_local_influence.mixpoissonreg}
\alias{local_influence_benchmarks.mixpoissonreg}
\title{Tidy Functions for Local Influence Diagnostics for \code{mixpoissonreg} Objects}
\usage{
\method{tidy_local_influence}{mixpoissonreg}(
  model,
  perturbation = c("case_weights", "hidden_variable", "mean_explanatory",
    "precision_explanatory", "simultaneous_explanatory"),
  curvature = c("conformal", "normal"),
  direction = c("canonical", "max.eigen"),
  parameters = c("all", "mean", "precision"),
  mean.covariates = NULL,
  precision.covariates = NULL,
  ...
)

\method{local_influence_benchmarks}{mixpoissonreg}(
  model,
  perturbation = c("case_weights", "hidden_variable", "mean_explanatory",
    "precision_explanatory", "simultaneous_explanatory"),
  curvature = c("conformal", "normal"),
  direction = c("canonical", "max.eigen"),
  parameters = c("all", "mean", "precision"),
  mean.covariates = NULL,
  precision.covariates = NULL,
  ...
)
}
\arguments{
\item{model}{A \code{mixpoissonreg} model.}

\item{perturbation}{a list or vector of perturbation schemes to be returned. The currently available schemes are
"case_weights", "hidden_variable", "mean_explanatory", "precision_explanatory", "simultaneous_explanatory". See Barreto-Souza and Simas (2016) for further details.}

\item{curvature}{the curvature to be returned, 'conformal' for the conformal normal curvature (see Zhu and Lee, 2001 and Poon and Poon, 1999) or
'normal' (see Zhu and Lee, 2001 and Cook, 1986).}

\item{direction}{the 'max.eigen' returns the eigenvector associated to the largest eigenvalue of the perturbation matrix. The 'canonical' considers
the curvatures under the canonical directions, which is known as "total local curvature" (see Lesaffre and Verbeke, 1998). For conformal
normal curvatures both of them coincide. The default is 'canonical'.}

\item{parameters}{the parameter to which the local influence will be computed. The options are 'all', 'mean' and 'precision'.
This argument affects the 'case_weights' and 'hidden_variable' perturbation schemes. The default is 'all'.}

\item{mean.covariates}{a list or vector of characters containing the mean-explanatory variables to be used in the 'mean-explanatory' and 'simultaneous-explanatory'
perturbation schemes. If NULL, the 'mean-explanatory' and 'simultaneous-explanatory' perturbation schemes will be computed by perturbing all
mean-related covariates. The default is NULL.}

\item{precision.covariates}{a list or vector of characters containing the precision-explanatory variables to be used in the 'precision-explanatory'
and 'simultaneous-explanatory'
perturbation schemes. If NULL, the 'precision-explanatory' and 'simultaneous-explanatory' perturbation schemes will be computed by perturbing all
precision-related covariates. The default is NULL.}

\item{...}{Currently not used.}
}
\value{
A tibble containing the perturbations schemes as columns.
}
\description{
Functions to provide tidy outputs of local influence diagnostics. \code{tidy_local_influence.mixpoissonreg}
provides a \code{\link[tibble:tibble]{tibble::tibble()}} containing the local influence diagnostics under the chosen perturbation schemes.
\code{local_influence_benchmarks.mixpoissonreg} provides a \code{\link[tibble:tibble]{tibble::tibble()}} with a single row and one column
for each selected perturbation scheme containing influential benchmarks for each perturbation scheme.
}
\examples{

daysabs_prog <- mixpoissonreg(daysabs ~ prog | prog, data = Attendance)
tidy_local_influence(daysabs_prog)

}
\references{
DOI:10.1007/s11222-015-9601-6 \doi{10.1007/s11222-015-9601-6}(Barreto-Souza and Simas; 2016)

Cook, R. D. (1986) \emph{Assessment of Local Influence.} Journal of the Royal Statistical Society. Series B (Methodological), Vol. 48, pp.133-169. \href{https://rss.onlinelibrary.wiley.com/doi/10.1111/j.2517-6161.1986.tb01398.x}{https://rss.onlinelibrary.wiley.com/doi/10.1111/j.2517-6161.1986.tb01398.x}

Lesaffre, E. and Verbeke, G. (1998) \emph{Local Influence in Linear Mixed Models}. Biometrics, 54, pp. 570-582.

Poon, W.-Y. and Poon, Y.S. (1999) \emph{Conformal normal curvature and assessment of local influence.}  Journal of the Royal Statistical Society. Series B (Methodological), Vol. 61, pp.51-61. \href{https://rss.onlinelibrary.wiley.com/doi/abs/10.1111/1467-9868.00162}{https://rss.onlinelibrary.wiley.com/doi/abs/10.1111/1467-9868.00162}

Zhu, H.-T. and Lee, S.-Y. (2001) \emph{Local influence for incomplete data models.} Journal of the Royal Statistical Society. Series B (Methodological), Vol. 63, pp.111-126. \href{https://rss.onlinelibrary.wiley.com/doi/abs/10.1111/1467-9868.00279}{https://rss.onlinelibrary.wiley.com/doi/abs/10.1111/1467-9868.00279}
}
\seealso{
\code{\link{glance.mixpoissonreg}}, \code{\link{augment.mixpoissonreg}}, \code{\link{tidy.mixpoissonreg}}, \code{\link{autoplot.mixpoissonreg}}
}
