% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_2d_scaling.R
\encoding{UTF-8}
\name{plot_2d_scaling}
\alias{plot_2d_scaling}
\title{Constructs a 2-dimensional scaling plot based on a given dissimilarity matrix.}
\usage{
plot_2d_scaling(distance_matrix, cluster_labels = NULL, title = "")
}
\arguments{
\item{distance_matrix}{A distance matrix.}

\item{cluster_labels}{The labels associated with the elements involving the
entries in \code{distance_matrix}. The points in the plot are coloured
according to these labels. If no labels are provided (default), all points
are represented in the same colour.}

\item{title}{The title of the graph (default is no title).}
}
\value{
The 2-dimensional scaling plane.
}
\description{
\code{plot_2d_scaling} represents a 2-dimensional scaling plane starting from
a dissimilarity matrix.
}
\details{
Given a distance matrix, the function constructs the corresponding 2-dimensional
scaling, which is a 2d plane in which the distances between the points represent
the original distances as correctly as possible. If the vector \code{cluster_labels}
is provided to the function, points in the 2d plane are coloured according to the
given class labels.
}
\examples{
distance_matrix_qcd <- dis_qcd(SyntheticData1$data[1 : 30]) # Computing the pairwise
# distance matrix for the first 30 elements in dataset SyntheticData1 based on dis_qcd
plot_2d_scaling(distance_matrix_qcd, cluster_labels = SyntheticData1$classes[1 : 30])
# Constructing the corresponding 2d-scaling plot. Each class is represented
# in a different colour
}
\author{
Ángel López-Oriona, José A. Vilar
}
