% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContextAsyncFSelect.R
\name{ContextAsyncFSelect}
\alias{ContextAsyncFSelect}
\title{Asynchronous Feature Selection Context}
\description{
A \link{CallbackAsyncFSelect} accesses and modifies data during the optimization via the \code{ContextAsyncFSelect}.
See the section on active bindings for a list of modifiable objects.
See \code{\link[=callback_async_fselect]{callback_async_fselect()}} for a list of stages that access \code{ContextAsyncFSelect}.
}
\details{
Changes to \verb{$instance} and \verb{$optimizer} in the stages executed on the workers are not reflected in the main process.
}
\section{Super classes}{
\code{\link[mlr3misc:Context]{mlr3misc::Context}} -> \code{\link[bbotk:ContextAsync]{bbotk::ContextAsync}} -> \code{ContextAsyncFSelect}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{auto_fselector}}{(\link{AutoFSelector})\cr
The \link{AutoFSelector} instance.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{xs_objective}}{(\code{list()})\cr
The feature subset currently evaluated.}

\item{\code{resample_result}}{(\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult})\cr
The resample result of the feature subset currently evaluated.}

\item{\code{aggregated_performance}}{(\code{list()})\cr
Aggregated performance scores and training time of the evaluated feature subset.
This list is passed to the archive.
A callback can add additional elements which are also written to the archive.}

\item{\code{result_feature_set}}{(character())\cr
The feature set passed to \code{instance$assign_result()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ContextAsyncFSelect-clone}{\code{ContextAsyncFSelect$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Context" data-id="format"><a href='../../mlr3misc/html/Context.html#method-Context-format'><code>mlr3misc::Context$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Context" data-id="print"><a href='../../mlr3misc/html/Context.html#method-Context-print'><code>mlr3misc::Context$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ContextAsync" data-id="initialize"><a href='../../bbotk/html/ContextAsync.html#method-ContextAsync-initialize'><code>bbotk::ContextAsync$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextAsyncFSelect-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ContextAsyncFSelect-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextAsyncFSelect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
