% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish_data.R
\name{publish_data}
\alias{publish_data}
\title{Upload data to OpenML}
\usage{
publish_data(
  data,
  name,
  desc,
  license = NULL,
  default_target = NULL,
  citation = NULL,
  row_identifier = NULL,
  ignore_attribute = NULL,
  original_data_url = NULL,
  paper_url = NULL,
  test_server = test_server_default(),
  api_key = NULL
)
}
\arguments{
\item{data}{(\code{\link[=data.frame]{data.frame()}})\cr
The data to upload.}

\item{name}{(\code{character(1)})\cr
The name of the dataset.}

\item{desc}{(\code{character(1)})\cr
The description of the dataset.}

\item{license}{(\code{character(1)})\cr
The license of the dataset}

\item{default_target}{(\code{character(1)})\cr
The default target variable.}

\item{citation}{(\code{character(1)})\cr
How to cite the dataset.}

\item{row_identifier}{(\code{character(1)})\cr
Whether any of the columns is a row identifier.}

\item{ignore_attribute}{(\code{character(1)})\cr
Which columns to ignore during modeling.}

\item{original_data_url}{(character(1))\cr
The URL of the original data set.}

\item{paper_url}{(\code{character(1)})\cr
The URL of the paper describing the data set.}

\item{test_server}{(\code{character(1)})\cr
Whether to use the OpenML test server or public server.
Defaults to value of option \code{"mlr3oml.test_server"}, or \code{FALSE} if not set.}

\item{api_key}{(\code{character(1)})
The API key to perform the action, if left NULL it first tries the "mlr3oml.api_key" R option and
then the environment variable \code{OPENMLAPIKEY}.

In case \code{test_server} is TRUE (only relevant for developers) the test server API key is used, i.e. first the option
"mlr3oml.test_api_key" and then the environment variable \code{TESTOPENMLAPIKEY}.}
}
\description{
Upload a dataset to OpenML.
This can also be achieved through the \href{https://www.openml.org}{website}.
}
