% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesNeighborhood.R
\name{neighborhood}
\alias{neighborhood}
\title{Given Bayesian features, returns those samples from a dataset that
exhibit a similarity (i.e., the neighborhood).}
\usage{
neighborhood(df, features, selectedFeatureNames = c(), retainMinValues = 0)
}
\arguments{
\item{df}{data.frame to select the neighborhood from}

\item{features}{data.frame of Bayes-features, used to segment/select the
rows that should make up the neighborhood.}

\item{selectedFeatureNames}{vector of names of features to use to demarcate
the neighborhood. If empty, uses all features' names.}

\item{retainMinValues}{DEFAULT 0 the amount of samples to retain during
segmentation. For separating a neighborhood, this value typically should
be 0, so that no samples are included that are not within it. However,
for very sparse data or a great amount of variables, it might still make
sense to retain samples.}
}
\value{
data.frame with rows that were selected as neighborhood. It is
guaranteed that the rownames are maintained.
}
\description{
The neighborhood \eqn{N_i} is defined as the set of samples that
have a similarity greater than zero to the given sample \eqn{s_i}. Segmentation
is done using equality (\code{==}) for discrete features and less than or equal
(\code{<=}) for continuous features. Note that feature values \code{NA} and \code{NaN}
are also supported using \code{is.na()} and \code{is.nan()}.
}
\examples{
nbh <- mmb::neighborhood(df = iris, features = mmb::createFeatureForBayes(
  name = "Sepal.Width", value = mean(iris$Sepal.Width)))

print(nrow(nbh))
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
\keyword{network}
