% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deck_funcs.R
\name{standard_deck}
\alias{standard_deck}
\title{Generate a Standard Deck of Playing Cards}
\usage{
standard_deck(
  suits = c("C", "D", "H", "S"),
  ranks = c("2", "3", "4", "5", "6", "7", "8", "9", "10", "J", "Q", "K", "A"),
  values = seq(2, 14.75, by = 0.25)
)
}
\arguments{
\item{suits}{A character vector specifying the suits in the deck. Default is
c('C', 'D', 'H', 'S') for Clubs, Diamonds, Hearts, and Spades.}

\item{ranks}{A character vector specifying the ranks in the deck. Default is
c('2', '3', '4', '5', '6', '7', '8', '9', '10', 'J', 'Q', 'K', 'A') for ranks
2 to Ace.}

\item{values}{A numeric vector specifying the values assigned to each card in
the deck. Default is a sequence from 2 to 14.75 incremented by 0.25.}
}
\value{
A data frame representing the deck of cards. The data frame has four
columns: \code{rank}, \code{suit}, \code{card}, and \code{value}. The data frame also has class
attributes "StandardDeck" and "data.frame".
}
\description{
This function creates a standard deck of playing cards represented as a data
frame. The deck includes suits, ranks, and values for each card.
}
\examples{
deck <- standard_deck()
head(deck)
tail(deck)

}
