% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_game_mgmt.R
\name{deal_cards_to_cc_grid}
\alias{deal_cards_to_cc_grid}
\title{Deal Cards to CloseCATs Game Grid}
\usage{
deal_cards_to_cc_grid(
  deck = mmcards::i_deck(deck = mmcards::shuffle_deck(), i_path = "www", i_names =
    c("2_of_clubs", "2_of_diamonds", "2_of_hearts", "2_of_spades", "3_of_clubs",
    "3_of_diamonds", "3_of_hearts", "3_of_spades", "4_of_clubs", "4_of_diamonds",
    "4_of_hearts", "4_of_spades", "5_of_clubs", "5_of_diamonds", "5_of_hearts",
    "5_of_spades", "6_of_clubs", "6_of_diamonds", "6_of_hearts", "6_of_spades",
    "7_of_clubs", "7_of_diamonds", "7_of_hearts", "7_of_spades", "8_of_clubs",
    "8_of_diamonds", "8_of_hearts", "8_of_spades", 
     "9_of_clubs", "9_of_diamonds",
    "9_of_hearts", "9_of_spades", "10_of_clubs", "10_of_diamonds", "10_of_hearts",
    "10_of_spades", "jack_of_clubs", "jack_of_diamonds", "jack_of_hearts",
    "jack_of_spades", "queen_of_clubs", "queen_of_diamonds", "queen_of_hearts",
    "queen_of_spades", "king_of_clubs", "king_of_diamonds", "king_of_hearts",
    "king_of_spades", "ace_of_clubs", "ace_of_diamonds", "ace_of_hearts",
    "ace_of_spades")),
  n
)
}
\arguments{
\item{deck}{A dataframe representing a deck of cards. If not provided, a
shuffled deck is generated using \code{mmcards::i_deck()} and
\code{mmcards::shuffle_deck()}. The deck should contain at least 2*n cards.}

\item{n}{The number of players. It defines the number of columns in the grid.
Each player, including the computer, will be dealt two cards.}
}
\value{
A matrix representing the game grid with dealt cards. Each cell of the
matrix contains a card dealt to either the computer (column 1) or the player
(column 2).
}
\description{
This internal function deals cards to a 2 x 2 grid for the CloseCATs game.
The game involves a deck of cards, where cards are dealt to both the computer
and the player. The matrix format of the game grid is such that column 1 is
for the computer, and column 2 is for the player. The first row of cards
contributes to the random slope variance, and the second row contributes to
the covariance between the random slope and the random intercept.
}
\keyword{internal}
