% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Paket_alle_Funktionen_3-26_21Juni2019.R
\docType{data}
\name{datasim}
\alias{datasim}
\title{Simulated Data Set With Three Endpoints}
\format{A data frame.}
\usage{
data(datasim)
}
\description{
A data set was simulated with repeated observations of a continous outcome variable Y.lin, a count data outcome Y.poi and a binary outcome Y.bin.
In the simulation, the mean of an outcome variable depends on the binary grouping variable gr.lang and one of the continuos predictors x1, x2 and x3.
Observations of all outcomes in the same subject, indicated by the variable id, are correlated. Also x1, x2 and x3 are correlated within subjects.
Data are independent between subjects. The example code shows how to fit a marginal GEE model for each outcome variable and how to test, with different methods,
the null hypothesis that the grouping variable has no effect on any of the three endpoints.
}
\examples{
data(datasim)
head(datasim)
mod1<-geem2(Y.lin~gr.lang+x1,id=id,data=datasim,family="gaussian",corstr="exchangeable")
mod2<-geem2(Y.poi~gr.lang+x2,id=id,data=datasim,family="poisson",corstr="exchangeable")
mod3<-geem2(Y.bin~gr.lang+x3,id=id,data=datasim,family="binomial",corstr="exchangeable")
L1<-L2<-L3<-matrix(c(0,1,0),nrow=1)
mmmgee.test(list(mod1,mod2,mod3),L=list(L1,L2,L3),statistic="Wald",type="maximum",
	biascorr=TRUE,asymptotic=FALSE,closed.test=TRUE)
\dontrun{
mmmgee.test(list(mod1,mod2,mod3),L=list(L1,L2,L3),statistic="score",closed.test=TRUE)
mmmgee.test(list(mod1,mod2,mod3),L=list(L1,L2,L3),statistic="score",type="quadratic",
	closed.test=TRUE)
mmmgee.test(list(mod1,mod2,mod3),L=list(L1,L2,L3),statistic="Wald",type="quadratic",
	biascorr=TRUE,asymptotic=FALSE,closed.test=TRUE)
mmmgee.test(list(mod1,mod2,mod3),L=list(L1,L2,L3),statistic="Wald",type="quadratic",
	scaled=TRUE,biascorr=TRUE,asymptotic=FALSE,closed.test=TRUE)
}
}
\keyword{datasets}
