% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_augment_no_data.R
\name{check_augment_no_data}
\alias{check_augment_no_data}
\title{Check an augment method when no data or newdata is passed}
\usage{
check_augment_no_data(aug, model, passed_data, strict = TRUE)
}
\arguments{
\item{aug}{An augment method. For example, \code{augment.betareg}.}

\item{model}{A fit model object to call the augment method on.}

\item{passed_data}{The dataset that \code{model} was original fit on that
\code{aug} should try to reconstruct when neither \code{data} nor \code{newdata} is
specified.}

\item{strict}{Logical indicating whether the strict version of tests should be used. Defaults
to \code{TRUE}.}
}
\value{
An invisible \code{NULL}. This function should be called for side effects, not return values.
}
\description{
Call this function to perform tests. If a tests fails, an informative error
will be thrown. Otherwise silent.

Test when \code{strict = FALSE}:
\itemize{
\item None
}

Additional tests when \code{strict = TRUE}:
\itemize{
\item \code{aug(model)} either returns an informative error or produces output
that passes \code{\link[=check_tibble]{check_tibble()}}.
\item If the output passes \code{check_tibble}, will issue warning when:
\itemize{
\item Augmented data is missing rows from original data.
\item Augmented data is missing columns from original data.
\item Original data has rownames but ugmented data is missing \code{.rownames}
column.
}
}
}
