% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{alaska_flights}
\alias{alaska_flights}
\title{Alaska flights data}
\format{
A data frame of 714 rows representing Alaska Airlines flights and 19 variables
\describe{
\item{year, month, day}{Date of departure.}
\item{dep_time, arr_time}{Actual departure and arrival times (format HHMM or HMM), local tz.}
\item{sched_dep_time, sched_arr_time}{Scheduled departure and arrival times (format HHMM or HMM), local tz.}
\item{dep_delay, arr_delay}{Departure and arrival delays, in minutes.
Negative times represent early departures/arrivals.}
\item{carrier}{Two letter carrier abbreviation. See \code{\link[nycflights13:airlines]{nycflights13::airlines}}
to get name.}
\item{flight}{Flight number.}
\item{tailnum}{Plane tail number. See \code{\link[nycflights13:planes]{nycflights13::planes}} for additional metadata.}
\item{origin, dest}{Origin and destination. See \code{\link[nycflights13:airports]{nycflights13::airports}} for
additional metadata.}
\item{air_time}{Amount of time spent in the air, in minutes.}
\item{distance}{Distance between airports, in miles.}
\item{hour, minute}{Time of scheduled departure broken into hour and minutes.}
\item{time_hour}{Scheduled date and hour of the flight as a \code{POSIXct} date.
Along with \code{origin}, can be used to join flights data to \code{\link[nycflights13:weather]{nycflights13::weather}} data.}
}
}
\source{
RITA, Bureau of transportation statistics
}
\usage{
alaska_flights
}
\description{
On-time data for all Alaska Airlines flights that departed NYC (i.e. JFK, LGA or EWR)
in 2013. This is a subset of the \code{flights} data frame from \code{nycflights13}.
}
\seealso{
\code{\link[nycflights13:flights]{nycflights13::flights}}.
}
\keyword{datasets}
