% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PXt.R
\name{PXt}
\alias{PXt}
\title{Tool to computate the transient probability distribution for a Continuous Time Markov Chain, CTMC.}
\usage{
PXt(X0, R, t, epsilon = 0.001)
}
\arguments{
\item{X0}{numeric vector, represents the probability distribution of the initial state.}

\item{R}{numeric, represents the rate matrix of a CTMC.}

\item{t}{numeric, represents the length of time.}

\item{epsilon}{numeric, represents the error bound of the approximation of P(t). Default values is 0.001.}
}
\description{
\code{Pt} is used to obtain the transient probability distribution of a homogeneous continuous time Markov chain at a point of time t.
}
\examples{
library(modesto)
# A three states CTMC example
R <- matrix(c(0,2,0,3,0,1,0,6,0),3,3,byrow=TRUE)
X0 <- c(1,0,0)
PXt(X0,R,t=0.5,epsilon=0.005)
X0 <- c(0,0,1)
PXt(X0,R,t=0.5,epsilon=0.005)

}
\references{
Ross, S, Introduction to Probability Models, Eleven Edition. Academic Press, 2014.

Kulkarni V, Introduction to modeling and analysis of stochastic systems. Second Edition. Springer-Verlag, 2011.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
