% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLikelihood.R
\name{LogLikelihood}
\alias{LogLikelihood}
\alias{modLL}
\alias{SURll}
\alias{modTable}
\alias{SURtable}
\title{Log-likelihood functions and Likelihood Ratio Tests for moderated networks}
\usage{
modLL(
  net0,
  net1 = NULL,
  nodes = FALSE,
  lrt = NULL,
  all = FALSE,
  d = 4,
  alpha = 0.05,
  orderBy = NULL,
  decreasing = TRUE
)

SURll(
  net0,
  net1 = NULL,
  nodes = FALSE,
  lrt = NULL,
  all = FALSE,
  d = 4,
  alpha = 0.05,
  s = "res",
  orderBy = NULL,
  decreasing = TRUE,
  sysfits = FALSE
)

modTable(
  net0,
  nodes = FALSE,
  orderBy = TRUE,
  d = 4,
  alpha = 0.05,
  decreasing = TRUE,
  names = NULL,
  rmsea = FALSE
)

SURtable(
  net0,
  nodes = FALSE,
  orderBy = TRUE,
  d = 4,
  alpha = 0.05,
  decreasing = TRUE,
  names = NULL,
  rmsea = FALSE,
  s = "res"
)
}
\arguments{
\item{net0}{Output from one of the main \code{modnets} functions.
Alternatively, a list of network models can be provided. This list should
be named for the easiest interpretation of results.}

\item{net1}{For \code{\link{modLL}} and \code{\link{SURll}}, can be used to
supply a second network to compare to \code{net0} via an LRT. Or if
\code{lrt = FALSE}, then relevant statistics will be returned for both
\code{net0} and \code{net1}. Importantly, if one network is provided for
\code{net0}, and another is provided for \code{net1}, then the names in the
output will reflect these argument names. This can be somewhat confusing at
times, so ultimately it is not recommended to use this argument. Instead,
try supplying both networks (or more) as a named list to the \code{net0}
argument for the most customization.}

\item{nodes}{Logical. Determines whether to compute omnibus or nodewise
statistics and tests. If \code{TRUE}, then LL values for nodewise models
will be returned, and any LRTs requested will reflect nodewise tests.}

\item{lrt}{Logical. Determines whether to conduct an LRT or not. If
\code{FALSE}, then only LL-related statistics will be returned for all
models supplied. Only relevant for \code{\link{modLL}} and
\code{\link{SURll}}}

\item{all}{Logical. If \code{TRUE}, then omnibus LL statistics as well as
nodewise statistics are returned for either LL function.}

\item{d}{Number of decimal places to round outputted statistics to.}

\item{alpha}{Alpha level for LRTs. Defaults to .05.}

\item{orderBy}{Can be one of \code{"LL", "df", "AIC", "BIC"} to indicate
which statistic to order the table by. If using \code{\link{modTable}} or
\code{\link{SURtable}}, then a value of \code{TRUE} will organize the
output by the LRT column, which indicates the number of times that a
particular model performed better than another based on the pairwise LRTs.
Higher values indicate that the model was selected more often in comparison
with other models in the list.}

\item{decreasing}{Logical. Determines whether to organize output from highest
to lowest, or vice versa, in accordance with the value of \code{orderBy}.}

\item{s}{Character string indicating which type of residual covariance matrix
to compute for SUR models. Options include \code{"res", "dfres", "sigma"}.
\code{"sigma"} uses the residual covariance matrix as computed by the
\code{\link[systemfit:systemfit]{systemfit::systemfit}} function.
\code{"res"} and \code{"dfres"} compute the matrix based directly on the
residual values. \code{"dfres"} is the sample estimator that uses \code{N -
  1} in the denominator, while \code{"res"} just uses \code{N}.}

\item{sysfits}{Logical, only relevant to \code{\link{SURll}} when multiple
networks are included in a list. Does not currently work when there are two
networks in the list, but does work with 3 or more. Returns the omnibus
model statistics based on functions available to output from the
\code{\link[systemfit:systemfit]{systemfit::systemfit}} function. This
allows for some additional statistics such as \code{SSR, detSigma, OLS.R2,
  McElroy.R2}.}

\item{names}{Character vector containing the names of the models being
compared. Only relevant to the \code{\link{modTable}} and
\code{\link{SURtable}}. Alternatively, models can be named by supplying a
named list to the \code{net0} argument.}

\item{rmsea}{Logical. Relevant to \code{\link{modTable}} and
\code{\link{SURtable}}. Determines whether to return RMSEA values, as well
as tests comparing RMSEA across each pair of models.}
}
\value{
A table or list of results depending on which function is used.
}
\description{
Computes log-likelihood, AIC, and BIC for a whole network, or for each node
in the network. Also compares two or more networks using a likelihood ratio
test (LRT).
}
\details{
Fits LRT to a list of network models to compare them all against each other.
Obtain all possible LRTs comparing a list of SUR models. Can include tests
comparing RMSEA values. The \code{nodes} argument determines whether to
perform these computations in an omnibus or nodewise fashion.

One key thing to note is that when using \code{\link{modTable}} or
\code{\link{SURtable}}, the LRT column indicates the number of times that
each network was selected over others with respect to the pairwise LRTs.
}
\examples{
data <- na.omit(psychTools::msq[, c('hostile', 'lonely', 'nervous', 'sleepy', 'depressed')])

##### Use modLL() for GGMs
ggm1 <- fitNetwork(data[, -5])
ggm2 <- fitNetwork(data, covariates = 5)
ggm3 <- fitNetwork(data, moderators = 5)

modLL(ggm1)
modLL(ggm2)

modLL(ggm1, ggm2)
modLL(ggm1, ggm2, nodes = TRUE)

modLL(list(ggm1 = ggm1, ggm2 = ggm2))
modLL(list(GGM1 = ggm1, GGM2 = ggm2), nodes = TRUE)

ggms <- list(ggm1, ggm2, ggm3)

modLL(ggms)
modTable(ggms)
modTable(ggms, names = c("GGM1", "GGM2", "GGM3"))

names(ggms) <- c("GGM1", "GGM2", "GGM3")
modTable(ggms)
modLL(ggms)

##### Use SURll() for SUR networks
sur1 <- fitNetwork(data[, -5], lags = TRUE)
sur2 <- fitNetwork(data, covariates = 5, lags = TRUE)
sur3 <- fitNetwork(data, moderators = 5, lags = TRUE)

SURll(sur1)
SURll(sur2)

SURll(sur1, sur2)
SURll(sur1, sur2, nodes = TRUE)
SURll(list(SUR1 = sur1, SUR2 = sur2), nodes = TRUE)

surs <- list(sur1, sur2, sur3)

SURll(surs)
SURtable(surs, names = c('SUR1', "SUR2", "SUR3"))

names(surs) <- c("SUR1", "SUR2", "SUR3")
SURll(surs)
SURtable(surs)
}
\seealso{
\code{\link{fitNetwork}, \link{mlGVAR}}
}
