% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmerVAR.R
\name{compareVAR}
\alias{compareVAR}
\title{Compare two to three \code{\link{lmerVAR}} models}
\usage{
compareVAR(m1, m2, m3 = NULL, anova = NULL, type = "tempMods")
}
\arguments{
\item{m1}{Output from \code{\link{lmerVAR}}.}

\item{m2}{Output from another run of \code{\link{lmerVAR}}. Necessary to supp}

\item{m3}{Output from a third run of \code{\link{lmerVAR}}. This is optional.}

\item{anova}{If \code{NULL}, then the results of each nodewise comparison
will be displayed. If numeric, then this indicates which nodewise
comparison to home in on. \code{anova = 1} will show the full ANOVA results
for the first predictor. \code{anova = 2} will show the full ANOVA results
for the second predictor, etc.}

\item{type}{Character string. Either \code{"tempMods"} or
\code{"contempMods"}. Determines whether to compare the temporal network
outputs or the contemporaneous network outputs with ANOVA.}
}
\value{
Table of ANOVA results comparing two or three models.
}
\description{
Affords ANOVAs to compare two or three \code{\link{lmerVAR}} models. It is
necessary to supply at least two different models for comparison, although a
third can also be supplied if desired.
}
\details{
Performs individual nodewise model comparisons across multiple
\code{\link{lmerVAR}} models.
}
\examples{
\donttest{
fit1 <- lmerVAR(mlgvarDat, temporal = "fixed", contemp = "orthogonal")
fit2 <- lmerVAR(mlgvarDat, temporal = "orthogonal", contemp = "orthogonal")

compareVAR(fit1, fit2)
}
}
\seealso{
\code{\link{lmerVAR}}
}
