% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simNet.R
\name{simNet}
\alias{simNet}
\title{Simulate network structure and data}
\usage{
simNet(
  N = 100,
  p = 5,
  m = FALSE,
  m2 = 0.1,
  b1 = NULL,
  b2 = NULL,
  sparsity = 0.5,
  intercepts = NULL,
  nIter = 250,
  msym = FALSE,
  onlyDat = FALSE,
  pbar = TRUE,
  div = 10,
  gibbs = TRUE,
  ordinal = FALSE,
  nLevels = 5,
  mord = FALSE,
  time = TRUE,
  mbinary = FALSE,
  minOrd = 3,
  m1 = NULL,
  m1_range = NULL,
  m2_range = c(0.1, 0.3),
  modType = "none",
  lags = NULL,
  V = 2,
  skewErr = FALSE,
  onlyNets = FALSE,
  netArgs = NULL,
  nCores = 1,
  cluster = "SOCK",
  getChains = FALSE,
  const = 1.5,
  fixedPar = NULL,
  V2 = 1,
  ...
)
}
\arguments{
\item{N}{Numeric value. Total number of subjects.}

\item{p}{Numeric value. Total number of nodes (excluding moderator).}

\item{m}{If a value is provided, a moderator is generated and named \code{M}
in the resultant data. If \code{TRUE}, then a normal distribution with a
mean of 0 will be used to generate the initial value of \code{m}, which
will serve as the population mean for \code{m} throughout the simulation.
If a numeric value is provided, then this will serve as the population
mean, and all subsequent draws will be taken from a normal distribution
with that mean. If \code{m = "binary"}, then this will simply set the
argument \code{mbinary = TRUE}. If \code{m = "ordinal"}, this will set
\code{mord = TRUE}. To simulate \code{m} from a skewed distribution, there
are two options: if \code{m = "skewed"}, then the \code{alpha} parameter of
the \code{\link[sn:rmsn]{sn::rmsn}} will automatically be set to 3.
Alternatively, a vector of length two can be supplied, containing the
element \code{"skewed"} as well as the desired value of \code{alpha}.
Lastly, a function can be provided for \code{m} if the user wishes to
sample \code{m} from another distribution. The requirement is that the
function have only one argument, and only returns a single numeric value.
The input of the argument should be the location parameter of the desired
sampling distribution.}

\item{m2}{Numeric. If \code{m2 >= 1}, then this will determine the number of
interaction effects between the moderator and some node in the network. If
a value between 0 and 1 is provided, then this determines the probability
of any given edge being moderated by the moderator.}

\item{b1}{Can provide an adjacency matrix to use for generating data.}

\item{b2}{Can provide an interaction matrix for generated moderated data.}

\item{sparsity}{Numeric value between 0 and 1. Determines the sparsity of
sampled network matrices.}

\item{intercepts}{A vector of means for sampling node values.}

\item{nIter}{Number of iterations for generating each instance of a datapoint
with the Gibbs sampler.}

\item{msym}{If \code{TRUE} then will force the interaction matrix to be
symmetric.}

\item{onlyDat}{If \code{TRUE} then the function only returns the simulated
data.}

\item{pbar}{If \code{TRUE} then a progress bar will be shown as samples are
generated.}

\item{div}{A value to use as a sign that the sampler diverged. Can be
increased based on expected range of values. If a datapoint is larger than
\code{div}, then the sampler will stop.}

\item{gibbs}{If \code{TRUE}, then Gibbs sampling will be used. Otherwise,
data are generated from the \code{\link[mvtnorm:rmvnorm]{mvtnorm::rmvnorm}}
function based on the partial correlation matrix that is created.}

\item{ordinal}{Logical. Determines whether to generate ordinal values or not.}

\item{nLevels}{Number of levels for the ordinal variables. Only relevant if
\code{ordinal} is not \code{FALSE}.}

\item{mord}{Logical. Determines whether the moderator variable should be
simulated as ordinal.}

\item{time}{If \code{TRUE} then the time it takes to simulate the data is
printed to screen at the end of the sampling.}

\item{mbinary}{Logical. Determines whether the moderator should be a binary
variable.}

\item{minOrd}{The minimum number of unique values allowed for each variable.}

\item{m1}{Functions similarly to \code{m2}, except that this argument refers
to the number/probability of main effects of the moderator on any given
node.}

\item{m1_range}{Numeric vector of length 2. The range of values for moderator
main effect coefficients.}

\item{m2_range}{Numeric vector of length 2. The range of values for moderator
interaction effect coefficients.}

\item{modType}{Determines the type of moderation to employ, such as
\code{"none", "full", "partial"}. If \code{modType = "full"}, then for any
interaction terms there will be full moderation, such that all pairwise
relationships for moderated paths will be set to zero. If \code{modType =
  "partial"}, then pairwise edges for moderated paths will always be nonzero.
If \code{modType = "none"}, no constraints will be applied (e.g., could
produce a mix between full and partial moderation).}

\item{lags}{If \code{TRUE} or 1, then arguments are rerouted to the
\code{\link{mlGVARsim}} function to simulate temporal data for a single
individual.}

\item{V}{Numeric, either 1 or 2. Determines whether to randomize the order of
simulating node values at each iteration of the Gibbs sampler. If \code{V =
  2}, then the order is randomized at each iteration. If \code{V = 1}, then
the sampler moves through the nodes from the first to the last in order at
each iteration.}

\item{skewErr}{The skewness parameter for the \code{alpha} argument in the
\code{\link[sn:rmsn]{sn::rmsn}} function. Only relevant when \code{gibbs =
  FALSE} and no moderator is specified.}

\item{onlyNets}{If \code{TRUE} then only the network models are returned,
without the data. Could be used to create random models and then simulate
data by another method.}

\item{netArgs}{Only for use by the internal function
\code{modnets:::simNet2}, which serves as a wrapper for the current
function to prevent it from failing.}

\item{nCores}{Numeric value indicating the number of CPU cores to use for the
resampling. If \code{TRUE}, then the
\code{\link[parallel:detectCores]{parallel::detectCores}} function will be
used to maximize the number of cores available.}

\item{cluster}{Character vector indicating which type of parallelization to
use, if \code{nCores > 1}. Options include \code{"mclapply"} and
\code{"SOCK"}.}

\item{getChains}{Logical. Determines whether to return the data-generating
chains from the Gibbs sampler.}

\item{const}{Numeric. The constant to be used by the internal
\code{modnets:::simPcor} function.}

\item{fixedPar}{Numeric. If provided, then this will be set as the
coefficient value for all edges in the network. Provides a way to
standardize the parameter values while varying the sparsity of the network.
If \code{length(fixedPar) == 1}, then the same value will be used for all
parameters. If \code{length(fixedPar) == 2}, then the first value will be
for pairwise relationships, and the second value will be for interaction
terms.}

\item{V2}{If \code{V2 = 1} and \code{m2} is between 0 and 1, the number of
interaction terms in the model will be determined by multiplying \code{m2}
with the number of elements in the interaction matrix and taking the
\code{ceiling}.}

\item{...}{Additional arguments.}
}
\value{
Simulated network models as well as data generated from those models.
For GGMs, model matrices are always symmetric. For temporal networks (when
\code{lags = 1}), columns predict rows.
}
\description{
Used for generating moderated and unmoderated adjacency matrices, along with
data based on those model structures.
}
\details{
If no moderator is specified then data can be generated directly from a
partial correlation matrix by setting \code{gibbs = FALSE}, which produces
fast simulation results. Alternatively, a Gibbs sampler is used to generate
data, which is the default option. For moderated networks, Gibbs sampling is
the only method available.
}
\section{Warning}{


Importantly, the Gibbs sampler can easily diverge given certain model
parameters. Generating network data based on moderator variables can
produce data that quickly take on large values due to the presence of
multiplicative terms. If the simulation fails, first simply try re-running
the function with a different seed; this will often be sufficient to solve
the problem when default parameters are specified. Additionally, one can
increase the value of \code{div}, in case the sampler only diverges
slightly or simply produced an anomalous value. This raises the threshold
of tolerated values before the sampler stops. If supplying user-generated
model matrices (for the \code{b1} and/or \code{b2} arguments) and the
function continues to fail, you will likely need to change the parameter
values in those matrices, as it may not be possible to simulate data under
the given values. If simulating the model matrices inside the function (as
is the default) and the function continues to fail, try adjusting the
following parameters: \enumerate{ \item{Try reducing the value of \code{m2}
to specify fewer interactions}. \item{Try reducing a range with a smaller
maximum for \code{m2_range}, to adjust the range of interaction
coefficients}. \item{Try adjusting the corresponding main effect parameters
for the moderator, \code{m1} and \code{m1_range}}. \item{Try setting
\code{modType = "full"} to reduce the number of main effect parameters}.
\item{Try setting a low value(s) for \code{fixedPar}, in order to provide
parameter values that are known to be lower} }

An alternative approach could be to use the internal function
\code{simNet2}, which is a wrapper designed to re-run \code{simNet} when it
fails and automatically adjust simulation parameters such as \code{div} to
thoroughly test a given parameterization scheme. This function can be
accessed via \code{modnets:::simNet2}. There is not documentation for this
function, so it is recommended to look at the source code if one wishes to
use it This wrapper is also used inside the \code{mnetPowerSim} function.
}

\examples{

# Generate a moderated GGM along with data
set.seed(1)
x <- simNet(N = 100, p = 3, m = TRUE)

net(x) # Get data-generating adjacency matrix
netInts(x) # Get data-generating interaction matrix

plot(x) # Plot the moderated network that generated the data

# Generate a single-subject GVAR model with data
set.seed(1)
x <- simNet(N = 500, p = 3, m = TRUE, lags = 1)

net(x, n = 'temporal') # Get the data-generating time-lagged adjacency matrix
net(x, n = 'contemporaneous') # Get the data-generating standardized residual covariance matrix

plot(x, which.net = 'beta') # 'beta' is another way of referring to the temporal network
plot(x, which.net = 'pcc') # 'pcc' is another way of referring to the contemporaneous network
}
\seealso{
\code{\link{mlGVARsim}, \link{mnetPowerSim}, \link{plotNet},
  \link{net}, \link{netInts}, \link{plotBoot}, \link{plotCoefs}}
}
