% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnetPowerSim.R
\name{summary.mnetPower}
\alias{summary.mnetPower}
\title{Descriptive statistics for power simulation results}
\usage{
\method{summary}{mnetPower}(object, ind = "all", order = NULL, decreasing = FALSE, ...)
}
\arguments{
\item{object}{Output from \code{\link{mnetPowerSim}} function.}

\item{ind}{Character string or vector to indicate which aspects of the
results to view. If \code{"means"}, then only the means will be returned
for all performance indices. \code{"sds"} returns the standard deviations,
\code{"ses"} returns the standard errors, and \code{"medians"} returns the
medians. These statistics describe the sample distributions according to
each combination of input parameters, and with regard to all performance
indices. Any combination of these options will return a list with each
table as a separate element. \code{"all"} returns a list of length 4 with
tables for all 4 types of statistic.}

\item{order}{Character string referring to which output index to organize
output by.}

\item{decreasing}{Logical. Determines whether to organize values from highest
to lowest or vice versa according to the value of the \code{order}
argument.}

\item{...}{Additional arguments.}
}
\value{
Summary table, or list of summary tables.
}
\description{
A quick way to view the results of power simulations conducted with
\code{\link{mnetPowerSim}}.
}
\examples{
\donttest{
x <- mnetPowerSim(niter = 10, N = c(100, 200))
summary(x)
plot(x)
}
}
\seealso{
\code{\link{mnetPowerSim}}
}
