% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNE3dDiscard.R
\name{DNE3dDiscard}
\alias{DNE3dDiscard}
\title{Plot advanced results of a DNE surface analysis}
\usage{
DNE3dDiscard(
  DNE_File,
  baseCol = "gray",
  boundCol = "red",
  outlierCol = "lawngreen",
  concaveCol = baseCol,
  main = "",
  cex = 1,
  cex.main = 2.5,
  legend = T,
  leftOffset = 1,
  fieldofview = 0,
  fileName = NA,
  binary = FALSE
)
}
\arguments{
\item{DNE_File}{An object that stores the output of the \code{DNE()}
function}

\item{baseCol}{Base color for typical face on surface. Default is gray}

\item{boundCol}{Color for the boundary faces discarded from
the DNE calculation. Default is red.}

\item{outlierCol}{Color for the faces discarded as outliers from
the DNE calculation. Default is lawngreen}

\item{concaveCol}{Color of the Concave faces on the surface.
When left in default concave faces remain undistinguished on
the plotted surface and are colored the same as baseCol.}

\item{main}{string indicating plot title. Defaults to empty}

\item{cex}{numeric value setting the relative size of the legend, default=1}

\item{cex.main}{numeric value setting the relative size of the plot title,}

\item{legend}{Logical indicating whether or not a legend
shold be displayed. Default=T}

\item{leftOffset}{numeric value between -1 and 1 setting the degree of
offset for the plotted surface to the left. Larger values set further to right.
Default=1}

\item{fieldofview}{Passes an argument to \code{par3d()} changing the field of
view (in degrees) of the resulting 3D plot}

\item{fileName}{String indicating a name to save the plotted surface to as a
*.ply file; default of 'NA' will not save a file}

\item{binary}{Logical indicating whether or not the saved surface plot should
be binary, passed to \code{vcgPlyWrite()}}
}
\description{
a molaR surface plotting function
}
\details{
This function creates a surface map of the discarded DNE faces.
DNE calculations typically discard the top 1 tenth of one percent of faces,
associated with extreme pockets and broken parts of surfaces. DNE
calculations also typically discard the boundary faces from the calculation,
either on the basis of 2 vertices on the boundary, or at least one vertext on
the boundary. concaveCol defaults to gray and therefore is turned off. When
an alternative color is provided, the function will identify the the areas of the
tooth that are concave vs convex.

Details of the other function arguments can be found in the DNE3d() description
and identical terms are organized to function the same way.
}
\examples{
DNE_output <- DNE(Tooth)
DNE3dDiscard(DNE_output)
}
