% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_motifs.R
\name{motif_summary}
\alias{motif_summary}
\title{Summary for motif counts and Erdős-Rényi distribution}
\usage{
motif_summary(net, lvl_attr = c("sesType"))
}
\arguments{
\item{net}{network object}

\item{lvl_attr}{character vector specifying the attribute name where level
information is stored in \code{net}.}
}
\value{
dataframe with motif counts, expectations and variances for set of
  selected motifs
}
\description{
Returns a data frame with counts and statistical properties (expectation,
variances) of six selected motifs in the given network. Note that this
function implicitly assumes that the network is undirected, cf.
\code{motifr::to_py_graph}.
}
\examples{
\dontrun{
motif_summary(ml_net)
}
}
