% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moveLocErrorCalc.R
\name{moveLocErrorCalc}
\alias{moveLocErrorCalc}
\title{moveLocError calculator for ARGOS or state space models resulting in 95percent latlon confidence intervals}
\usage{
moveLocErrorCalc(
  x,
  loncol = "lon",
  latcol = "lat",
  latloncrs = 4326,
  projectedcrs = 32617,
  lon025 = "lon025",
  lon975 = "lon975",
  lat025 = "lat025",
  lat975 = "lat975"
)
}
\arguments{
\item{x}{Data frame or tibble with lats and lons and their high and low confidence interval
counterparts.}

\item{loncol}{Name of longitude column in x, character. Default "lon".}

\item{latcol}{Name of latitude column in x, character. Default "lat".}

\item{latloncrs}{CRS of x, default 4326, numeric.}

\item{projectedcrs}{CRS to project to, should match your region, default 32617, numeric. See
movegroup projectedCRS.}

\item{lon025}{Name of low 2.5\% confidence interval longitude column in x, character. Default
"lon025".}

\item{lon975}{Name of high 2.5\% confidence interval longitude column in x, character. Default
"lon975".}

\item{lat025}{Name of low 2.5\% confidence interval latitude column in x, character. Default
"lat025".}

\item{lat975}{Name of high 2.5\% confidence interval latitude column in x, character. Default
"lat975".}
}
\value{
Dataframe of original locations plus rowmeans of mean distance of location extremities,
for use in movegroup::movegroup(moveLocError).
}
\description{
Builds a dataframe of original locations plus rowmeans of mean distance of location extremities
lon975, lat; lon025, lat; lon, lat975; lon, lat025 from the centre point lon, lat.
}
\details{
Use on your data object from movegroup::movegroup(data).
}
\examples{
data(argosFiltered)
myMoveLocError <- moveLocErrorCalc(argosFiltered)

}
\author{
Simon Dedman, \email{simondedman@gmail.com}
}
