% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_diagnostics.R
\name{autolayer}
\alias{autolayer}
\alias{autolayer.OnsetsSelected}
\alias{autolayer.Metre}
\alias{autolayer.Duration}
\alias{autolayer.Splice}
\title{Autolayer methods}
\usage{
\method{autolayer}{OnsetsSelected}(
  object,
  time_limits = c(-Inf, Inf),
  colour = "Inst.Name",
  fill = "Metre",
  alpha = 0.4,
  instrument_cols = NULL,
  ...
)

\method{autolayer}{Metre}(
  object,
  time_limits = c(-Inf, Inf),
  colour = "hotpink",
  alpha = 0.5,
  tempo = FALSE,
  view = NULL,
  columns = NULL,
  ...
)

\method{autolayer}{Duration}(
  object,
  time_limits = c(-Inf, Inf),
  expr = .data$Tier == "FORM",
  fill_column = "Comments",
  geom = "rect",
  vline_column = "In",
  ...
)

\method{autolayer}{Splice}(object, geom = "rect", vline_column = "Start", ...)
}
\arguments{
\item{object}{S3 object}

\item{time_limits}{tuple of time limits.}

\item{colour}{name of column for colouring.}

\item{fill}{name of column for filling.}

\item{alpha}{aesthetic}

\item{instrument_cols}{instrument column names.}

\item{...}{passed to geom.}

\item{tempo}{do we plot tempo with a Metre layer? (Default is FALSE).}

\item{view}{view object for a tempo Metre layer (Default is NULL).}

\item{columns}{columns for view for a tempo Metre layer (Default is NULL).}

\item{expr}{unquoted R expression for filtering data (default is Tier =='FORM').}

\item{fill_column}{data column used for fill.}

\item{geom}{'rect' or 'vline'.}

\item{vline_column}{column name for position of vertical lines.}
}
\value{
ggplot geom object
}
\description{
Layers of annotation data to add to ggplots in `movementsync.
}
\examples{
\donttest{
r<-get_recording("NIR_ABh_Puriya", fps=25)
o <- get_onsets_selected_data(r)
v <- get_raw_view(r, "Central", "", "Sitar")
autoplot(v, columns = c("LEar_x", "LEar_y"), maxpts=5000) + autolayer(o)

m <- get_metre_data(r)
autoplot(v, columns = c("LEar_x", "LEar_y"), time_limits = c(1000, 2000)) +
  autolayer(m, time_limits = c(1000, 2000))
autoplot(v, columns = c("LEar_x", "LEar_y"), time_limits = c(1000, 2000)) +
  autolayer(m, tempo = TRUE, time_limits = c(1000, 2000), view = v,
            columns = c("LEar_x", "LEar_y"))

d <- get_duration_annotation_data(r)
autoplot(m)
autoplot(m) + autolayer(d)
autoplot(m) + autolayer(d, fill_col = "Tier")

v <- get_raw_view(r, "Central", "", "Sitar")
autoplot(v, columns = c("LEar_x", "LEar_y")) +
  autolayer(d)
autoplot(v, columns = c("LEar_x", "LEar_y")) +
  autolayer(d, expr = Tier == "FORM" & substr(Comments, 1, 1) == "J")
autoplot(v, columns = c("LEar_x", "LEar_y")) +
  autolayer(d, geom = "vline", nudge_x = -60, size = 3, colour = "blue")
}
}
