% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.R
\name{accuracy}
\alias{accuracy}
\title{Accuracy measures}
\usage{
accuracy(pred, obs, na.rm = FALSE, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{pred}{a numeric vector with the predicted values.}

\item{obs}{a numeric vector with the observed values.}

\item{na.rm}{a logical indicating whether \link{NA}
values should be stripped before the computation proceeds.}

\item{tol}{divide underflow tolerance.}
}
\value{
Returns a named vector with the following components:
\itemize{
\item \code{me} mean error
\item \code{rmse} root mean squared error
\item \code{mae} mean absolute error
\item \code{mpe} mean percent error
\item \code{mape} mean absolute percent error
\item \code{r.squared} pseudo R-squared
}
}
\description{
Computes accuracy measurements.
}
\examples{
set.seed(1)
nobs <- nrow(bodyfat)
itrain <- sample(nobs, 0.8 * nobs)
train <- bodyfat[itrain, ]
test <- bodyfat[-itrain, ]
fit <- lm(bodyfat ~ abdomen + wrist, data = train)
pred <- predict(fit, newdata = test)
obs <- test$bodyfat
pred.plot(pred, obs)
accuracy(pred, obs)
}
\seealso{
\code{\link[=pred.plot]{pred.plot()}}
}
