% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_rate.R
\name{response_rate}
\alias{response_rate}
\title{Calculate response rate}
\usage{
response_rate(
  data,
  valid_col,
  participant_col,
  time_col = NULL,
  period_start = NULL,
  period_end = NULL
)
}
\arguments{
\item{data}{data frame with data}

\item{valid_col}{name of the column that stores whether the beep
was answered or not}

\item{participant_col}{name of the column that stores the participant id
(or equivalent)}

\item{time_col}{optional: name of the column that stores the time of the
beep, as a 'POSIXct' object.}

\item{period_start}{string representing the starting date to
calculate response rates (optional). Accepts dates in the following
formats: \code{yyyy-mm-dd} or\code{yyyy/mm/dd}.}

\item{period_end}{period end to calculate response rates (optional).}
}
\value{
a data frame with the response rate for each participant, and the number of beeps used to
calculate the response rate
}
\description{
Calculate response rate
}
\examples{
# Example 1: calculate response rates for the whole study
# Get example data
data(example_data)

# Calculate response rate for each participant

# We don't specify time_col, period_start or period_end.
# Response rates will be based on all the participant's data
response_rate <- response_rate(data = example_data,
                               valid_col = answered,
                               participant_col = participant)

# Example 2: calculate response rates for a specific time period
data(example_data)

# Calculate response rate for each participant between dates
response_rate <- response_rate(data = example_data,
                               valid_col = answered,
                               participant_col = participant,
                               time_col = sent,
                               period_start = '2024-05-15',
                               period_end = '2024-05-31')

# Get participants with a response rate below 0.5
response_rate[response_rate$response_rate < 0.5,]

}
