% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrct_functions.R
\name{innerProduct}
\alias{innerProduct}
\title{Pairwise inner product for \eqn{L^2} functions}
\usage{
innerProduct(grid, data)
}
\arguments{
\item{grid}{A numeric vector of the uniform grid on which the functions are evaluated.}

\item{data}{A numeric matrix. Each function has to be a vector stored in a column of \code{data} and evaluated at the points of \code{grid}.
Thus, the number of rows and columns of \code{data} correspond to \code{length(grid)} and the number of functions, respectively.}
}
\value{
Numeric symmetric matrix containing the approximated pairwise inner products between the functions supplied by \code{data}. The entry \eqn{(i,j)} of the result is the inner product
between the \eqn{i}-th and \eqn{j}-th column of \code{data}.
}
\description{
Calculate all pairwise inner products between elements from \eqn{L^2} supplied to this function. The integral is approximated by the Trapezoidal rule for uniform grids:
\deqn{ \int_a^b f(x) dx \approx \Delta x \left( \sum_{i=1}^{N-1} f(x_i) + \frac{f(x_N) - f(x_0)}{2} \right) }
whereas \eqn{ \{x_i \}} is an uniform grid on \eqn{[a,b]} such that \eqn{a = x_0 < x_1 < \ldots < x_N = b} and \eqn{\Delta x} the step size, i.e. \eqn{\Delta x := x_2 - x_1}.
Therefore, it is assumed that the functions are evaluated at the same, equidistant grid.
}
\examples{
# Create orthogonal fourier basis via `fdapace` package
library(fdapace)
basis <- fdapace::CreateBasis(K = 10,
                              type = "fourier")
iP <- innerProduct(grid = seq(0, 1, length.out = 50), # default grid in CreateBasis()
                   data = basis)
round(iP,3)
# Since the basis is orthogonal, the resulting matrix will be the identity matrix.
}
