% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrct_functions.R
\name{mrct.ise}
\alias{mrct.ise}
\title{Integrated square error}
\usage{
mrct.ise(data, outliers.est, model)
}
\arguments{
\item{data}{Numeric matrix of a functional data set for which the esimator has to be calculated. Each row contains an observation. They are assumed to be observed on the same regular grid.}

\item{outliers.est}{Integer vector containing the indices of outliers.}

\item{model}{Integer. \eqn{1} correspond to the first outlier setting, whereas \eqn{2} and \eqn{3} are related to the remaining two, which both have the same kernel.}
}
\value{
Numeric value containing the approximated integrated square error between estimated and theoretical covariance.
}
\description{
Calculates the approximation of the integrated square error between the estimated covariance based
on non-outlying curves of a data set determined by the MRCT estimator and the true kernel for one of the three outlier settings in the simulation study of \insertCite{oguamalam2023minimum;nobrackets}{mrct}.
}
\examples{
# Fix seed for reproducibility
set.seed(124)

# Sample outlying indices
cont.ind <- sample(1:100,size=10)

# Generate 100 curves on the interval [0,1] at 150 timepoints with 20\% outliers.
y <- mrct.rgauss(x.grid=seq(0,1,length.out=150), N=100, model=1,
                 outliers=cont.ind, method="linear")
# Run MRCT
mrct.y <- mrct(data=y, h=0.75, alpha=0.1,
               initializations=10, criterion="sum")
# Two additional curves are regarded as outlying according to the algorithm
mrct.y$theoretical.w \%in\% cont.ind
# Compare the ISE between true kernel and 1) true non-outliers,
# 2) estimated non-outliers and 3) the complete data
ise1 <- mrct.ise(data=y, outliers.est=cont.ind, model=1)
ise2 <- mrct.ise(data=y, outliers.est=mrct.y$theoretical.w, model=1)
ise3 <- mrct.ise(data=y, outliers.est=c(), model=1)
ise1; ise2; ise3

}
\references{
\insertRef{oguamalam2023minimum}{mrct}.
}
