% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msamp.R
\name{n}
\alias{n}
\title{Calculate the sample size necessary to detect contamination above
target level}
\usage{
n(
  C,
  w,
  G,
  Sens,
  D = c("homogeneous", "heterogeneous", "localized"),
  r = NULL,
  f = NULL,
  prob_det = 0.9,
  samp_dollar,
  lot_dollar
)
}
\arguments{
\item{C}{suspected lot contamination (CFU/g)}

\item{w}{weight of single sample unit (g)}

\item{G}{target value to detect (CFU/g)}

\item{Sens}{sensitivity of the analytical test (\%)}

\item{D}{distribution of the bacteria in the product lot: "homogeneous", "heterogeneous", or "localized"}

\item{r}{for the heterogeneous case only, the degree of heterogeneity. r > 0}

\item{f}{for the localized case, r is further specified. 0 < f < 1}

\item{prob_det}{desired probability of detecting bacterial contamination above the
target level in the product lot. Set to 0.9 by default}

\item{samp_dollar}{cost per sample unit in $}

\item{lot_dollar}{fixed cost (if any) of sampling the lot in $}
}
\value{
A list containing:
\itemize{
\item{\strong{n}: }{The sample size}
\item{\strong{p}: }{The probability of a single sample unit being contaminated above the
target level}
\item{\strong{cost_tot}: }{The total cost associated with sampling of
\emph{n} samples}
}
}
\description{
The n() function calculates the sample size,n, necessary to detect contamination above
a target level, G, in a product lot, where the probability of a single sample unit being above
the target level is calculated by the msamp function p(). The total cost, cost_tot,
associated with sample size is also output.
}
\details{
Refer to vignette for details.
}
\examples{

#A sample of 25 grams (w=25) is collected and analyzed using an analytical
#test with sensitivity of 90\% (Sens=.9), to detect at least 5 CFU's/g (G=5).
#The suspected or postulated level of contamination in the lot is 4 CFU's/g (C=4).
#The desired probability of picking at least one sample unit contaminated above the target
#level is 0.9 (prob_det=0.9), the cost of a single sampling unit is $100 (samp_dollar=100),
#and the fixed cost for sampling the entire lot is $200 (lot_dollar=200).

#homogeneous case
n(C=4,w=25,G=5,Sens=.9,D="homogeneous",r=NULL,f=NULL,prob_det=0.9,samp_dollar=100,lot_dollar=200)
# n=376, total cost=$37,722
#heterogeneous case
n(C=4,w=25,G=5,Sens=.9,D="heterogeneous",r=10,f=NULL,prob_det=0.9,samp_dollar=100,lot_dollar=200)
# n=12, total cost=$1,319
#localized case
n(C=4,w=25,G=5,Sens=.9,D="localized",r=NULL,f=.3,prob_det=0.9,samp_dollar=100,lot_dollar=200)
# n=1,254 , total cost=$125,541

}
