% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msamp.R
\name{plotn}
\alias{plotn}
\title{Plots the relation between the probability of detection and the sample size, n}
\usage{
plotn(
  C,
  w,
  G,
  Sens,
  D = c("homogeneous", "heterogeneous", "localized"),
  r = NULL,
  f = NULL
)
}
\arguments{
\item{C}{suspected lot contamination (CFU/g)}

\item{w}{weight of single sample unit (g)}

\item{G}{target value to detect (CFU/g)}

\item{Sens}{sensitivity of the analytical test (\%)}

\item{D}{distribution of the bacteria in the product lot: "homogeneous", "heterogeneous", or "localized"}

\item{r}{for the heterogeneous case only, the degree of heterogeneity. r > 0}

\item{f}{for the localized case, r is further specified. 0 < f < 1}
}
\value{
A plot, of recordedplot class. The probability of detection is on the y-axis and
the  sample size n is on the x-axis. Overlaid at intersecting red dashed lines is the
sample size for probability of detection (prob_det) = 0.9.
}
\description{
The plotn() function examines the effect of increasing the probability of detection
on the sample size, n, where the probability of a single sample unit being contaminated
above the target limit is calculated from the msamp function p()
}
\details{
Refer to vignette for details.
}
