# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' R wrapper for the \code{CalcMatchFactor} C++ function.
#'
#' @description
#'   Call the \code{CalcMatchFactor} C++ function.
#'
#' @param ms_u,ms_l
#'   A numeric matrix. Mass values, weighted and original intensities (see the
#'   \code{\link{LibrarySearch}} function).
#' @param is_identity
#'   A logical value. If \code{TRUE}, the Identity algorithm is used to
#'   calculate the match factor. If \code{FALSE}, the Similarity algorithm is
#'   used.
#' @param min_mz,max_mz
#'   An integer value. Boundaries of the m/z range.
#' @param is_reverse_search
#'   A logical value. If \code{TRUE}, reverse search is performed and RMF is
#'   returned.
#'
#' @details
#'   All m/z values should be unique and sorted in the accessing order.
#'   Original intensities of mass spectral peaks should be normalized; the base
#'   peak should have intensity of 999. Any checks of the input data are not
#'   performed (i.e., if m/z values are not sorted in the ascending order, the
#'   calculated match factor is going to be incorrect).
#'
#' @return
#'   A numeric value. The match factor calculated between a pair of mass
#'   spectra.
#'
#' @noRd
#'
.CalcMatchFactorC <- function(ms_u, ms_l, is_identity, min_mz = -1L, max_mz = -1L, is_reverse_search = FALSE, is_debugging = FALSE) {
    .Call(`_mssearchr_CalcMatchFactor`, ms_u, ms_l, is_identity, min_mz, max_mz, is_reverse_search, is_debugging)
}

