% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.msfit.R
\name{summary.msfit}
\alias{summary.msfit}
\title{Summary method for an msfit object}
\usage{
\method{summary}{msfit}(
  object,
  times,
  transitions,
  variance = TRUE,
  conf.int = 0.95,
  conf.type = c("log", "none", "plain"),
  extend = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of class 'msfit', containing estimated cumulative
transition intensities for all transitions in a multi-state model}

\item{times}{Time points at which to evaluate the cumulative transition
hazards}

\item{transitions}{The transition for which to summarize the cumulative
transition hazards}

\item{variance}{Whether or not the standard errors of the estimated
cumulative transition intensities should be printed; default is \code{TRUE}}

\item{conf.int}{The proportion to be covered by the confidence intervals,
default is 0.95}

\item{conf.type}{The type of confidence interval, one of "log", "none", or
"plain". Defaults to "log"}

\item{extend}{logical value: if \code{TRUE}, prints information for all
specified times, even if there are no subjects left at the end of the
specified times. This is only valid if the times argument is present}

\item{\dots}{Further arguments to summary}
}
\value{
Function \code{summary.msfit} returns an object of class
"summary.msfit", which is a list (for each \code{from} state) of cumulative
transition hazaards at the specified (or all) time points. The \code{print}
method of a \code{summary.probtrans} doesn't return a value.
}
\description{
Summary method for an object of class 'msfit'. It prints a selection of the
estimated cumulative transition intensities, and, if requested, also of the
(co)variances.
}
\examples{

# Start with example from msfit
tmat <- trans.illdeath()
tg <- data.frame(illt=c(1,1,6,6,8,9),ills=c(1,0,1,1,0,1),
                 dt=c(5,1,9,7,8,12),ds=c(1,1,1,1,1,1),
                 x1=c(1,1,1,0,0,0),x2=c(6:1))
tglong <- msprep(time=c(NA,"illt","dt"),status=c(NA,"ills","ds"),
                 data=tg,keep=c("x1","x2"),trans=tmat)
tglong <- expand.covs(tglong,c("x1","x2"))
cx <- coxph(Surv(Tstart,Tstop,status)~x1.1+x2.2+strata(trans),
            data=tglong,method="breslow")
newdata <- data.frame(trans=1:3,x1.1=c(0,0,0),x2.2=c(0,1,0),strata=1:3)
msf <- msfit(cx,newdata,trans=tmat)

# Default, all transitions, with SE
summary(msf)
summary(msf, conf.type="plain")
# Only transitions 1 and 3
summary(msf, tra=c(1, 3))
# Default is 95\% confidence interval, change here to 90\% 
summary(msf, conf.int=0.90)
# Do not show variances (nor confidence intervals)
summary(msf, variance=FALSE)
# Cumulative hazards only at specified time points
summary(msf, times=seq(0, 15, by=3))
# Last specified time point is larger than last observed, not printed
# Use extend=TRUE as in summary.survfit
summary(msf, times=seq(0, 15, by=3), extend=TRUE)
# Different types of confidence intervals, default is log
summary(msf, times=seq(0, 15, by=3), conf.type="plain")
summary(msf, times=seq(0, 15, by=3), conf.type="no")
# When the number of time points specified is larger than 12, head and tail is shown
x <- summary(msf, times=seq(5, 8, by=0.25))
x

}
\seealso{
\code{\link{msfit}}
}
\author{
Hein Putter \email{H.Putter@lumc.nl}
}
\keyword{print}
