% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_gain.R
\name{information_gain}
\alias{information_gain}
\alias{information_gain}
\alias{IG}
\title{Estimating information gain between two categorical variables.}
\usage{
information_gain(x, y)

IG(x, y)
}
\arguments{
\item{x}{A factor representing a categorical variable.}

\item{y}{A factor representing a categorical variable.}
}
\value{
Information gain estimation based on Sannon entropy for
    variables \code{x} and \code{y}.
}
\description{
Information gain (also called mutual information) is a measure of
the mutual dependence between two variables (see
\url{https://en.wikipedia.org/wiki/Mutual_information}).
}
\examples{
information_gain(factor(c(0,1)), factor(c(1,0)))
information_gain(factor(c(0,0,1,1)), factor(c(0,1,1,1)))
information_gain(factor(c(0,0,1,1)), factor(c(0,1,0,1)))
\dontrun{
information_gain(c(0,1), c(1,0))
}
}
