% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cmc.df}
\alias{cmc.df}
\title{Contraceptive Method Choice data}
\format{
A data.frame with 1473 rows and 10 columns:
\describe{
\item{age}{Wife's age}
\item{edu}{Wife's education}
\item{eduh}{Husband's education}
\item{nborn}{Number of children ever born}
\item{islam}{Wife's religion}
\item{working}{Wife is now working?}
\item{husocc}{Husband's occupation}
\item{sol}{Standard-of-living index}
\item{medex}{Media exposure}
\item{method}{Contraceptive method used}
}
}
\source{
Tjen-Sien Lim 'Contraceptive Method Choice' 1997,
   UCI Machine Learning Repository [http://archive.ics.uci.edu/ml]. 
  Irvine, CA: University of California, School of Information and Computer 
  Science.
}
\usage{
data(cmc.df)
}
\description{
This dataset is a subset of the 1987 National Indonesia Contraceptive
Prevalence Survey. The cases are 1473 married women who were either not 
pregnant or do not know if they were at the time of interview.
}
\details{
The variables 'age' (in years) and 'nborn' (ranging from 0 to 16) would
normally be treated as continuous; 'nborn' is skew and might well
be transformed. The remaining 8 variables are categorical. 

The variables 'edu', 'eduh' and 'sol' take values '1,2,3,4', #' they are 
ordinal with 1 = low and 4 = high. The variable 'husocc' takes the
same 4 values, but it is not clear if the order has any significance.

The variables 'islam', 'working', and 'medex' are binary-valued with
0=Non-Islam, 1=Islam for 'islam';  0=Yes, 1=No for 'working'; and 0=Good, 
1=Not good for 'medex'.

The variable 'method' is ternary: 1=No-use, 2=Long-term, 3=Short-term.
}
\keyword{datasets}
