% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{buildChord}
\alias{buildChord}
\title{Build Chord}
\usage{
buildChord(
  root,
  chord = "minor",
  play = FALSE,
  plot = FALSE,
  formatNotation = TRUE,
  ...
)
}
\arguments{
\item{root}{String: Root note}

\item{chord}{String: Chord to build. Default = "minor"}

\item{play}{Logical: If TRUE, play chord using \link{playChord}}

\item{plot}{Logical: If TRUE, plot chord notes using \link{cplot.piano}}

\item{formatNotation}{Logical: If TRUE, format notes to include both flats and sharps
to avoid repeating the same letter. e.g. convert c("Gb4", "G4") to c("F#4", "G4")}

\item{...}{Additional arguments to be passed to \link{playChord} if \code{play = TRUE}}
}
\description{
Build Chord
}
\examples{
buildChord("C4", "minor")
buildChord("A4", "sus2", plot = TRUE)
\dontrun{
buildChord("B4", "sus2", play = TRUE)
}
}
\author{
E.D. Gennatas
}
