% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlasso.R
\name{nlasso_path}
\alias{nlasso_path}
\title{Fit a linear model with natural lasso}
\usage{
nlasso_path(x, y, lambda = NULL, nlam = 100, flmin = 0.01,
  thresh = 1e-08, intercept = TRUE, glmnet_output = NULL)
}
\arguments{
\item{x}{An \code{n} by \code{p} design matrix. Each row is an observation of \code{p} features.}

\item{y}{A response vector of size \code{n}.}

\item{lambda}{A user specified list of tuning parameter. Default to be NULL, and the program will compute its own \code{lambda} path based on \code{nlam} and \code{flmin}.}

\item{nlam}{The number of \code{lambda} values. Default value is \code{100}.}

\item{flmin}{The ratio of the smallest and the largest values in \code{lambda}. The largest value in \code{lambda} is usually the smallest value for which all coefficients are set to zero. Default to be \code{1e-2}.}

\item{thresh}{Threshold value for the underlying optimization algorithm to claim convergence. Default to be \code{1e-8}.}

\item{intercept}{Indicator of whether intercept should be fitted. Default to be \code{TRUE}.}

\item{glmnet_output}{Should the estimate be computed using a user-specified output from \code{glmnet}. If not \code{NULL}, it should be the output from \code{glmnet} call with \code{standardize = TRUE}, and then the arguments \code{lambda}, \code{nlam}, \code{flmin}, \code{thresh}, and \code{intercept} will be ignored. Default to be \code{NULL}, in which case the function will call \code{glmnet} internally.}
}
\value{
A list object containing: \describe{
\item{\code{n} and \code{p}: }{The dimension of the problem.}
\item{\code{lambda}: }{The path of tuning parameters used.}
\item{\code{beta}: }{Matrix of estimates of the regression coefficients, in the original scale. The matrix is of size \code{p} by \code{nlam}. The \code{j}-th column represents the estimate of coefficient corresponding to the \code{j}-th tuning parameter in \code{lambda}.}
\item{\code{a0}: }{Estimate of intercept. A vector of length \code{nlam}.}
\item{\code{sig_obj_path}: }{Natural lasso estimates of the error standard deviation. A vector of length \code{nlam}.}
\item{\code{sig_naive_path}: }{Naive estimates of the error standard deviation based on lasso regression, i.e., \eqn{||y - X \hat{\beta}||_2 / \sqrt n}. A vector of length \code{nlam}.}
\item{\code{sig_df_path}: }{Degree-of-freedom adjusted estimate of standard deviation of the error. A vector of length \code{nlam}. See Reid, et, al (2016).}
\item{\code{type}: }{whether the output is of a natural or an organic lasso.}}
}
\description{
Calculate a solution path of the natural lasso estimate (of error standard deviation) with a list of tuning parameter values. In particular, this function solves the lasso problems and returns the lasso objective function values as estimates of the error variance:
\eqn{\hat{\sigma}^2_{\lambda} = \min_{\beta} ||y - X \beta||_2^2 / n + 2 \lambda ||\beta||_1.}
The output also includes a path of naive estimates and a path of degree of freedom adjusted estimates of the error standard deviation.
}
\examples{
set.seed(123)
sim <- make_sparse_model(n = 50, p = 200, alpha = 0.6, rho = 0.6, snr = 2, nsim = 1)
nl_path <- nlasso_path(x = sim$x, y = sim$y[, 1])
}
\seealso{
\code{\link{nlasso_cv}}
}
