% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olasso_api.R
\name{olasso_cv}
\alias{olasso_cv}
\title{Cross-validation for organic lasso}
\usage{
olasso_cv(x, y, lambda = NULL, intercept = TRUE, nlam = 100,
  flmin = 0.01, nfold = 5, foldid = NULL, thresh = 1e-08)
}
\arguments{
\item{x}{An \code{n} by \code{p} design matrix. Each row is an observation of \code{p} features.}

\item{y}{A response vector of size \code{n}.}

\item{lambda}{A user specified list of tuning parameter. Default to be NULL, and the program will compute its own \code{lambda} path based on \code{nlam} and \code{flmin}.}

\item{intercept}{Indicator of whether intercept should be fitted. Default to be \code{TRUE}.}

\item{nlam}{The number of \code{lambda} values. Default value is \code{100}.}

\item{flmin}{The ratio of the smallest and the largest values in \code{lambda}. The largest value in \code{lambda} is usually the smallest value for which all coefficients are set to zero. Default to be \code{1e-2}.}

\item{nfold}{Number of folds in cross-validation. Default value is 5. If each fold gets too view observation, a warning is thrown and the minimal \code{nfold = 3} is used.}

\item{foldid}{A vector of length \code{n} representing which fold each observation belongs to. Default to be \code{NULL}, and the program will generate its own randomly.}

\item{thresh}{Threshold value for underlying optimization algorithm to claim convergence. Default to be \code{1e-8}.}
}
\value{
A list object containing: \describe{
\item{\code{n} and \code{p}: }{The dimension of the problem.}
\item{\code{lambda}: }{The path of tuning parameter used.}
\item{\code{beta}: }{Estimate of the regression coefficients, in the original scale, corresponding to the tuning parameter selected by cross-validation.}
\item{\code{a0}: }{Estimate of intercept}
\item{\code{mat_mse}: }{The estimated prediction error on the test sets in cross-validation. A matrix of size \code{nlam} by \code{nfold}}
\item{\code{cvm}: }{The averaged estimated prediction error on the test sets over K folds.}
\item{\code{cvse}: }{The standard error of the estimated prediction error on the test sets over K folds.}
\item{\code{ibest}: }{The index in \code{lambda} that attains the minimal mean cross-validated error.}
\item{\code{foldid}: }{Fold assignment. A vector of length \code{n}.}
\item{\code{nfold}: }{The number of folds used in cross-validation.}
\item{\code{sig_obj}: }{Organic lasso estimate of the error standard deviation, selected by cross-validation.}
\item{\code{sig_obj_path}: }{Organic lasso estimates of the error standard deviation. A vector of length \code{nlam}.}
\item{\code{type}: }{whether the output is of a natural or an organic lasso.}}
}
\description{
Provide organic lasso estimate (of the error standard deviation) using cross-validation to select the tuning parameter value
}
\examples{
set.seed(123)
sim <- make_sparse_model(n = 50, p = 200, alpha = 0.6, rho = 0.6, snr = 2, nsim = 1)
ol_cv <- olasso_cv(x = sim$x, y = sim$y[, 1])
}
\seealso{
\code{\link{olasso_path}, \link{olasso}}
}
