% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olasso_api.R
\name{olasso_path}
\alias{olasso_path}
\title{Fit a linear model with organic lasso}
\usage{
olasso_path(x, y, lambda = NULL, nlam = 100, flmin = 0.01,
  thresh = 1e-08, intercept = TRUE)
}
\arguments{
\item{x}{An \code{n} by \code{p} design matrix. Each row is an observation of \code{p} features.}

\item{y}{A response vector of size \code{n}.}

\item{lambda}{A user specified list of tuning parameter. Default to be NULL, and the program will compute its own \code{lambda} path based on \code{nlam} and \code{flmin}.}

\item{nlam}{The number of \code{lambda} values. Default value is \code{100}.}

\item{flmin}{The ratio of the smallest and the largest values in \code{lambda}. The largest value in \code{lambda} is usually the smallest value for which all coefficients are set to zero. Default to be \code{1e-2}.}

\item{thresh}{Threshold value for underlying optimization algorithm to claim convergence. Default to be \code{1e-8}.}

\item{intercept}{Indicator of whether intercept should be fitted. Default to be \code{FALSE}.}
}
\value{
A list object containing: \describe{
\item{\code{n} and \code{p}: }{The dimension of the problem.}
\item{\code{lambda}: }{The path of tuning parameter used.}
\item{\code{a0}: }{Estimate of intercept. A vector of length \code{nlam}.}
\item{\code{beta}: }{Matrix of estimates of the regression coefficients, in the original scale. The matrix is of size \code{p} by \code{nlam}. The \code{j}-th column represents the estimate of coefficient corresponding to the \code{j}-th tuning parameter in \code{lambda}.}
\item{\code{sig_obj_path}: }{Organic lasso estimates of the error standard deviation. A vector of length \code{nlam}.}
\item{\code{sig_naive}: }{Naive estimate of the error standard deviation based on the squared-lasso regression. A vector of length \code{nlam}.}
\item{\code{sig_df}: }{Degree-of-freedom adjusted estimate of the error standard deviation, based on the squared-lasso regression. A vector of length \code{nlam}. }
\item{\code{type}: }{whether the output is of a natural or an organic lasso.}}
}
\description{
Calculate a solution path of the organic lasso estimate (of error standard deviation) with a list of tuning parameter values. In particular, this function solves the squared-lasso problems and returns the objective function values as estimates of the error variance:
\eqn{\tilde{\sigma}^2_{\lambda} = \min_{\beta} ||y - X \beta||_2^2 / n + 2 \lambda ||\beta||_1^2.}
}
\details{
This package also includes the outputs of the naive and the degree-of-freedom adjusted estimates, in analogy to \code{\link{nlasso_path}}.
}
\examples{
set.seed(123)
sim <- make_sparse_model(n = 50, p = 200, alpha = 0.6, rho = 0.6, snr = 2, nsim = 1)
ol_path <- olasso_path(x = sim$x, y = sim$y[, 1])

}
\seealso{
\code{\link{olasso}, \link{olasso_cv}}
}
